/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.Tranche;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TrancheExhaustionPoint")
@ImplementedBy(value=Default.class)
public interface TrancheExhaustionPoint
extends Validator<Tranche> {
    public static final String NAME = "TrancheExhaustionPoint";
    public static final String DEFINITION = "exhaustionPoint >= 0.0 and exhaustionPoint <= 1.0";

    public static class NoOp
    implements TrancheExhaustionPoint {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche tranche) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TrancheExhaustionPoint {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche tranche) {
            ComparisonResult result = this.executeDataRule(tranche);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TrancheExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheExhaustionPoint.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TrancheExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheExhaustionPoint.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Tranche tranche) {
            try {
                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)tranche).map("getExhaustionPoint", _tranche -> _tranche.getExhaustionPoint()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)tranche).map("getExhaustionPoint", _tranche -> _tranche.getExhaustionPoint()), (Mapper)MapperS.of((Object)new BigDecimal("1.0")), (CardinalityOperator)CardinalityOperator.All));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

