/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.validation.datarule;

import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PaymentDatesNonZeroPeriodMultiplier")
@ImplementedBy(value=Default.class)
public interface PaymentDatesNonZeroPeriodMultiplier
extends Validator<PaymentDates> {
    public static final String NAME = "PaymentDatesNonZeroPeriodMultiplier";
    public static final String DEFINITION = "if paymentDaysOffset exists then paymentDaysOffset -> periodMultiplier <> 0";

    public static class NoOp
    implements PaymentDatesNonZeroPeriodMultiplier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PaymentDates paymentDates) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PaymentDatesNonZeroPeriodMultiplier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PaymentDates paymentDates) {
            ComparisonResult result = this.executeDataRule(paymentDates);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PaymentDatesNonZeroPeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PaymentDates", (RosettaPath)path, (String)PaymentDatesNonZeroPeriodMultiplier.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PaymentDatesNonZeroPeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PaymentDates", (RosettaPath)path, (String)PaymentDatesNonZeroPeriodMultiplier.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PaymentDates paymentDates) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)paymentDates).map("getPaymentDaysOffset", _paymentDates -> _paymentDates.getPaymentDaysOffset())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)paymentDates).map("getPaymentDaysOffset", _paymentDates -> _paymentDates.getPaymentDaysOffset()).map("getPeriodMultiplier", offset -> offset.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.Any);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

