/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.validation.datarule;

import cdm.product.common.schedule.WeightedAveragingObservation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="WeightedAveragingObservationPositiveWeight")
@ImplementedBy(value=Default.class)
public interface WeightedAveragingObservationPositiveWeight
extends Validator<WeightedAveragingObservation> {
    public static final String NAME = "WeightedAveragingObservationPositiveWeight";
    public static final String DEFINITION = "weight >= 0.0";

    public static class NoOp
    implements WeightedAveragingObservationPositiveWeight {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, WeightedAveragingObservation weightedAveragingObservation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements WeightedAveragingObservationPositiveWeight {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, WeightedAveragingObservation weightedAveragingObservation) {
            ComparisonResult result = this.executeDataRule(weightedAveragingObservation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)WeightedAveragingObservationPositiveWeight.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"WeightedAveragingObservation", (RosettaPath)path, (String)WeightedAveragingObservationPositiveWeight.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)WeightedAveragingObservationPositiveWeight.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"WeightedAveragingObservation", (RosettaPath)path, (String)WeightedAveragingObservationPositiveWeight.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(WeightedAveragingObservation weightedAveragingObservation) {
            try {
                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)weightedAveragingObservation).map("getWeight", _weightedAveragingObservation -> _weightedAveragingObservation.getWeight()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

