/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FloatingRateCalculationMappingProcessor
extends MappingProcessor {
    public FloatingRateCalculationMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        MappingProcessorUtils.subPath((String)"capFloorStream", (Path)synonymPath).ifPresent(subPath -> {
            PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = (PriceQuantity.PriceQuantityBuilder)parent;
            MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (Path)subPath, (String[])new String[]{"capRateSchedule", "initialValue"}).ifPresent(m -> this.addPrice((Path)subPath, priceQuantityBuilder, (Mapping)m, ArithmeticOperationEnum.MIN));
            MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (Path)subPath, (String[])new String[]{"floorRateSchedule", "initialValue"}).ifPresent(m -> this.addPrice((Path)subPath, priceQuantityBuilder, (Mapping)m, ArithmeticOperationEnum.MAX));
        });
        MappingProcessorUtils.subPath((String)"swapStream", (Path)synonymPath).ifPresent(subPath -> {
            PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = (PriceQuantity.PriceQuantityBuilder)parent;
            MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (Path)subPath, (String[])new String[]{"floatingRateMultiplierSchedule", "initialValue"}).ifPresent(m -> this.addPrice((Path)subPath, priceQuantityBuilder, (Mapping)m, ArithmeticOperationEnum.MULTIPLY));
        });
    }

    private void addPrice(Path subPath, PriceQuantity.PriceQuantityBuilder priceQuantityBuilder, Mapping mapping, ArithmeticOperationEnum operator) {
        UnitType.UnitTypeBuilder unitType = this.toCurrencyUnitType(subPath);
        BigDecimal rate = new BigDecimal(String.valueOf(mapping.getXmlValue()));
        PriceTypeEnum priceType = PriceTypeEnum.INTEREST_RATE;
        FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder fieldWithPriceScheduleBuilder = PriceQuantityHelper.toReferencablePriceBuilder(rate, unitType, unitType, priceType, operator, null);
        PriceSchedule.PriceScheduleBuilder priceScheduleBuilder = fieldWithPriceScheduleBuilder.getValue();
        Path baseModelPath = PathUtils.toPath((RosettaPath)this.getModelPath());
        Path amountModelPath = PriceQuantityHelper.incrementPathElementIndex(baseModelPath, "price", CollectionUtils.emptyIfNull(priceQuantityBuilder.getPrice()).size());
        this.addMapping(mapping.getXmlPath(), mapping.getXmlValue(), amountModelPath, mapping.getXmlValue());
        priceScheduleBuilder.setDatedValue(this.getSteps(mapping.getXmlPath().getParent(), amountModelPath.getParent()));
        priceQuantityBuilder.addPrice(fieldWithPriceScheduleBuilder);
    }

    private UnitType.UnitTypeBuilder toCurrencyUnitType(Path startsWithPath) {
        String currency = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notionalStepSchedule", "currency"}).orElse(null);
        String currencyScheme = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notionalStepSchedule", "currency", "currencyScheme"}).orElse(null);
        return UnitType.builder().setCurrency(FieldWithMetaString.builder().setValue(currency).setMeta(MetaFields.builder().setScheme(currencyScheme).build()));
    }

    private List<DatedValue.DatedValueBuilder> getSteps(Path floorScheduleSynonymPath, Path priceScheduleModelPath) {
        Optional<DatedValue.DatedValueBuilder> step;
        ArrayList<DatedValue.DatedValueBuilder> steps = new ArrayList<DatedValue.DatedValueBuilder>();
        int index = 0;
        while ((step = this.getStep(floorScheduleSynonymPath, priceScheduleModelPath, index++)).isPresent()) {
            steps.add(step.get());
        }
        return steps;
    }

    private Optional<DatedValue.DatedValueBuilder> getStep(Path floorScheduleSynonymPath, Path priceScheduleModelPath, int index) {
        DatedValue.DatedValueBuilder stepBuilder = DatedValue.builder();
        Path synonymPath = floorScheduleSynonymPath.addElement("step", Integer.valueOf(index));
        Path modelPath = priceScheduleModelPath.addElement("step", Integer.valueOf(index));
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement("stepValue"), xmlValue -> stepBuilder.setValue(new BigDecimal((String)xmlValue)), (List)this.getMappings(), (RosettaPath)PathUtils.toRosettaPath((Path)modelPath.addElement("stepValue")));
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement("stepDate"), xmlValue -> stepBuilder.setDate(Date.parse((String)xmlValue)), (List)this.getMappings(), (RosettaPath)PathUtils.toRosettaPath((Path)modelPath.addElement("stepDate")));
        return stepBuilder.hasData() ? Optional.of(stepBuilder) : Optional.empty();
    }

    private void addMapping(Path xmlPath, Object xmlValue, Path modelPath, Object modelValue) {
        this.getMappings().add(new Mapping(xmlPath, xmlValue, modelPath, modelValue, null, true, true, false));
    }
}

