/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZonedDateTime;

public class CompareHelper {
    static int compare(Object o1, Object o2) {
        if (o1 instanceof ZonedDateTime && o2 instanceof ZonedDateTime) {
            return ((ZonedDateTime)o1).toInstant().compareTo(((ZonedDateTime)o2).toInstant());
        }
        if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
        if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
            throw new IllegalArgumentException("I only know how to compare identical comparable types and numbers not " + o1.getClass().getSimpleName() + " and " + o2.getClass().getSimpleName());
        }
        BigDecimal b1 = CompareHelper.toBigD((Number)o1);
        BigDecimal b2 = CompareHelper.toBigD((Number)o2);
        return b1.compareTo(b2);
    }

    private static BigDecimal toBigD(Number n) {
        if (n instanceof BigDecimal) {
            return CompareHelper.setScale((BigDecimal)n);
        }
        if (n instanceof Long) {
            return CompareHelper.setScale(new BigDecimal(n.longValue()));
        }
        if (n instanceof Integer) {
            return CompareHelper.setScale(new BigDecimal(n.intValue()));
        }
        throw new IllegalArgumentException("can only convert integer and long to bigD");
    }

    private static BigDecimal setScale(BigDecimal d) {
        return d.setScale(9, RoundingMode.HALF_UP);
    }
}

