/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.CompareHelper;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ErrorHelper;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.ListIterator;

class ExpressionEqualityUtil {
    ExpressionEqualityUtil() {
    }

    static <T, U, G> ComparisonResult evaluate(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o, ExpressionOperators.CompareFunction<Mapper<T>, Mapper<U>> func) {
        return func.apply(m1, m2, o);
    }

    static <T, U> ComparisonResult areEqual(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        if (m1 instanceof ComparisonResult) {
            m1 = ((ComparisonResult)m1).asMapper();
        }
        if (m2 instanceof ComparisonResult) {
            m2 = ((ComparisonResult)m2).asMapper();
        }
        if (m1.getClass().equals(m2.getClass())) {
            return ExpressionEqualityUtil.areEqualSame(m1, m2, o);
        }
        if (m1 instanceof MapperS) {
            return ExpressionEqualityUtil.areEqualDifferent((MapperC)m2, (MapperS)m1, o);
        }
        return ExpressionEqualityUtil.areEqualDifferent((MapperC)m1, (MapperS)m2, o);
    }

    private static <T> ComparisonResult areEqualSame(Mapper<T> m1, Mapper<T> m2, CardinalityOperator o) {
        List<T> multi1 = m1.getMulti();
        List<T> multi2 = m2.getMulti();
        ListIterator<T> e1 = multi1.listIterator();
        ListIterator<T> e2 = multi2.listIterator();
        if (multi1.isEmpty() || multi2.isEmpty()) {
            return ComparisonResult.failureEmptyOperand(ErrorHelper.formatEqualsComparisonResultError(m1) + " cannot be compared to " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        while (e1.hasNext() && e2.hasNext()) {
            boolean equals;
            T b1 = e1.next();
            T b2 = e2.next();
            if (b1 instanceof Number && b2 instanceof Number || b1 instanceof ZonedDateTime && b2 instanceof ZonedDateTime) {
                int compRes = CompareHelper.compare(b1, b2);
                equals = compRes == 0;
            } else {
                boolean bl = b1 == null ? b2 == null : (equals = b1.equals(b2));
            }
            if (!equals && o == CardinalityOperator.All) {
                return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " does not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
            }
            if (!equals || o != CardinalityOperator.Any) continue;
            return ComparisonResult.success();
        }
        if (e1.hasNext() || e2.hasNext()) {
            return ComparisonResult.failureEmptyOperand(ErrorHelper.formatEqualsComparisonResultError(m1) + " cannot be compared to " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        return o == CardinalityOperator.All ? ComparisonResult.success() : ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " does not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
    }

    private static <T, U> ComparisonResult areEqualDifferent(MapperC<T> m1, MapperS<U> m2, CardinalityOperator o) {
        List<T> multi1 = m1.getMulti();
        U b2 = m2.get();
        if (multi1.isEmpty()) {
            return ComparisonResult.failureEmptyOperand(ErrorHelper.formatEqualsComparisonResultError(m1) + " cannot be compared to " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        ListIterator<T> e1 = multi1.listIterator();
        while (e1.hasNext()) {
            boolean equals;
            T b1 = e1.next();
            if (b1 instanceof Number && b2 instanceof Number) {
                int compRes = CompareHelper.compare(b1, b2);
                if (compRes != 0 && o == CardinalityOperator.All) {
                    return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " does not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
                }
                if (compRes != 0 || o != CardinalityOperator.Any) continue;
                return ComparisonResult.success();
            }
            boolean bl = b1 == null ? b2 == null : (equals = b1.equals(b2));
            if (!equals && o == CardinalityOperator.All) {
                return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " does not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
            }
            if (!equals || o != CardinalityOperator.Any) continue;
            return ComparisonResult.success();
        }
        return o == CardinalityOperator.All ? ComparisonResult.success() : ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " does not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
    }

    static <T, U> ComparisonResult notEqual(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        if (m1.getClass().equals(m2.getClass())) {
            return ExpressionEqualityUtil.notEqualSame(m1, m2, o);
        }
        if (m1 instanceof MapperS) {
            return ExpressionEqualityUtil.notEqualDifferent((MapperC)m2, (MapperS)m1, o);
        }
        return ExpressionEqualityUtil.notEqualDifferent((MapperC)m1, (MapperS)m2, o);
    }

    private static <T> ComparisonResult notEqualSame(Mapper<T> m1, Mapper<T> m2, CardinalityOperator o) {
        List<T> multi1 = m1.getMulti();
        List<T> multi2 = m2.getMulti();
        ListIterator<T> e1 = multi1.listIterator();
        ListIterator<T> e2 = multi2.listIterator();
        if (multi1.isEmpty() || multi2.isEmpty()) {
            return ComparisonResult.successEmptyOperand(ErrorHelper.formatEqualsComparisonResultError(m1) + " cannot be compared to " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        while (e1.hasNext() && e2.hasNext()) {
            boolean equals;
            T b1 = e1.next();
            T b2 = e2.next();
            if (b1 instanceof Number && b2 instanceof Number) {
                int compRes = CompareHelper.compare(b1, b2);
                if (compRes != 0 && o == CardinalityOperator.Any) {
                    return ComparisonResult.success();
                }
                if (compRes != 0 || o != CardinalityOperator.All) continue;
                return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
            }
            boolean bl = b1 == null ? b2 == null : (equals = b1.equals(b2));
            if (!equals && o == CardinalityOperator.Any) {
                return ComparisonResult.success();
            }
            if (!equals || o != CardinalityOperator.All) continue;
            return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        if (e1.hasNext() || e2.hasNext()) {
            return ComparisonResult.success();
        }
        return o == CardinalityOperator.Any ? ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal " + ErrorHelper.formatEqualsComparisonResultError(m2)) : ComparisonResult.success();
    }

    private static <T, U> ComparisonResult notEqualDifferent(MapperC<T> m1, MapperS<U> m2, CardinalityOperator o) {
        List<T> multi1 = m1.getMulti();
        U b2 = m2.get();
        if (multi1.isEmpty()) {
            return ComparisonResult.successEmptyOperand(ErrorHelper.formatEqualsComparisonResultError(m1) + " cannot be compared to " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        ListIterator<T> e1 = multi1.listIterator();
        while (e1.hasNext()) {
            boolean equals;
            T b1 = e1.next();
            if (b1 instanceof Number && b2 instanceof Number) {
                int compRes = CompareHelper.compare(b1, b2);
                if (compRes != 0 && o == CardinalityOperator.Any) {
                    return ComparisonResult.success();
                }
                if (compRes != 0 || o != CardinalityOperator.All) continue;
                return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
            }
            boolean bl = b1 == null ? b2 == null : (equals = b1.equals(b2));
            if (!equals && o == CardinalityOperator.Any) {
                return ComparisonResult.success();
            }
            if (!equals || o != CardinalityOperator.All) continue;
            return ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal " + ErrorHelper.formatEqualsComparisonResultError(m2));
        }
        return o == CardinalityOperator.Any ? ComparisonResult.failure(ErrorHelper.formatEqualsComparisonResultError(m1) + " should not equal  " + ErrorHelper.formatEqualsComparisonResultError(m2)) : ComparisonResult.success();
    }
}

