/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.google.common.base.Strings;
import com.regnosys.rosetta.formatting2.RosettaFormatterPreferenceKeys;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class FormattingOptionsAdaptor {
    public static String PREFERENCE_INDENTATION_KEY = "indentation";
    public static String PREFERENCE_MAX_LINE_WIDTH_KEY = "maxLineWidth";
    public static String PREFERENCE_CONDITIONAL_MAX_LINE_WIDTH_KEY = "conditionalMaxLineWidth";

    public ITypedPreferenceValues createPreferences(FormattingOptions options) {
        Number maxLineWidth;
        MapBasedPreferenceValues preferences = new MapBasedPreferenceValues();
        String indent = "\t";
        if (options != null && options.isInsertSpaces()) {
            indent = Strings.padEnd((String)"", (int)options.getTabSize(), (char)' ');
        }
        preferences.put(PREFERENCE_INDENTATION_KEY, indent);
        if (options == null) {
            return preferences;
        }
        Number conditionalMaxLineWidth = options.getNumber(PREFERENCE_CONDITIONAL_MAX_LINE_WIDTH_KEY);
        if (conditionalMaxLineWidth != null) {
            preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.conditionalMaxLineWidth, (Object)conditionalMaxLineWidth.intValue());
        }
        if ((maxLineWidth = options.getNumber(PREFERENCE_MAX_LINE_WIDTH_KEY)) != null) {
            preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.maxLineWidth, (Object)maxLineWidth.intValue());
            if (conditionalMaxLineWidth == null) {
                int defaultConditionalMaxLineWidth = RosettaFormatterPreferenceKeys.conditionalMaxLineWidth.toValue(RosettaFormatterPreferenceKeys.conditionalMaxLineWidth.getDefaultValue());
                int defaultMaxLineWidth = RosettaFormatterPreferenceKeys.maxLineWidth.toValue(RosettaFormatterPreferenceKeys.maxLineWidth.getDefaultValue());
                double defaultRatio = (double)defaultConditionalMaxLineWidth / (double)defaultMaxLineWidth;
                preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.conditionalMaxLineWidth, (Object)((int)(maxLineWidth.doubleValue() * defaultRatio)));
            }
        }
        return preferences;
    }
}

