/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.regnosys.rosetta.formatting2.FormattingOptionsAdaptor;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;

public class FormattingOptionsService {
    private static final String DEFAULT_FORMATTING_OPTIONS_PATH = "default-formatting-options.json";
    @Inject
    private FormattingOptionsAdaptor optionsAdaptor;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public FormattingOptions getDefaultOptions() {
        InputStream resourceStream = ResourceLoader.class.getClassLoader().getResourceAsStream(DEFAULT_FORMATTING_OPTIONS_PATH);
        try {
            return this.fromInputStream(resourceStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read default formatting options.", e);
        }
    }

    public ITypedPreferenceValues getDefaultPreferences() {
        return this.optionsAdaptor.createPreferences(this.getDefaultOptions());
    }

    public FormattingOptions readOptionsFromFile(String optionsPath) throws IOException {
        FileInputStream resourceStream = new FileInputStream(optionsPath);
        return this.fromInputStream(resourceStream);
    }

    public ITypedPreferenceValues readPreferencesFromFile(String optionsPath) throws IOException {
        return this.optionsAdaptor.createPreferences(this.readOptionsFromFile(optionsPath));
    }

    private FormattingOptions fromInputStream(InputStream optionsStream) throws IOException {
        Map map = null;
        map = (Map)this.objectMapper.readValue(optionsStream, Map.class);
        FormattingOptions formattingOptions = new FormattingOptions();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                formattingOptions.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                formattingOptions.putNumber(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                formattingOptions.putBoolean(key, (Boolean)value);
                continue;
            }
            throw new IllegalArgumentException("Unsupported value type for key: " + key);
        }
        return formattingOptions;
    }
}

