/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.builtin.RosettaBuiltinsService;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseGuard;
import com.regnosys.rosetta.rosetta.expression.WithMetaEntry;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationDeepPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.scoping.AliasAwareImportNormalizer;
import com.regnosys.rosetta.scoping.PatchedImportNormalizer;
import com.regnosys.rosetta.scoping.ReversedSimpleScope;
import com.regnosys.rosetta.types.ExpectedTypeProvider;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceOption;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    public static final String LIB_NAMESPACE = "com.rosetta.model";
    private static final Logger LOGGER = LoggerFactory.getLogger(RosettaScopeProvider.class);
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private ExpectedTypeProvider expectedTypeProvider;
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private RosettaFunctionExtensions functionExtensions;
    @Inject
    private DeepFeatureCallUtil deepFeatureCallUtil;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private RosettaBuiltinsService builtinsService;

    public IScope getScope(EObject context, EReference reference) {
        try {
            if (reference.equals((Object)RosettaPackage.Literals.TYPE_CALL_ARGUMENT__PARAMETER)) {
                if (context instanceof TypeCall) {
                    TypeCall typeCall = (TypeCall)context;
                    RosettaType type = typeCall.getType();
                    if (type instanceof ParametrizedRosettaType) {
                        ParametrizedRosettaType paramType = (ParametrizedRosettaType)type;
                        return Scopes.scopeFor(paramType.getParameters());
                    }
                    return IScope.NULLSCOPE;
                }
            } else {
                if (reference.equals((Object)ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE)) {
                    if (context instanceof RosettaFeatureCall) {
                        RosettaFeatureCall featureCall = (RosettaFeatureCall)context;
                        return this.createExtendedFeatureScope(featureCall.getReceiver(), this.typeProvider.getRMetaAnnotatedType(featureCall.getReceiver()));
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)ExpressionPackage.Literals.ROSETTA_DEEP_FEATURE_CALL__FEATURE)) {
                    if (context instanceof RosettaDeepFeatureCall) {
                        RosettaDeepFeatureCall deepFeatureCall = (RosettaDeepFeatureCall)context;
                        return this.createDeepFeatureScope(this.typeProvider.getRMetaAnnotatedType(deepFeatureCall.getReceiver()).getRType());
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES)) {
                    if (context instanceof ChoiceOperation) {
                        ChoiceOperation op = (ChoiceOperation)context;
                        return this.createExtendedFeatureScope(op.getArgument(), RMetaAnnotatedType.withNoMeta(this.typeProvider.getRMetaAnnotatedType(op.getArgument()).getRType()));
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)RosettaPackage.Literals.ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE)) {
                    if (context instanceof RosettaAttributeReference) {
                        RosettaAttributeReference attrRef = (RosettaAttributeReference)context;
                        return this.createExtendedFeatureScope(attrRef.getReceiver(), RMetaAnnotatedType.withNoMeta(this.typeProvider.getRTypeOfAttributeReference(attrRef.getReceiver())));
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY)) {
                    if (context instanceof ConstructorKeyValuePair) {
                        RosettaConstructorExpression constructor = (RosettaConstructorExpression)context.eContainer();
                        return Scopes.scopeFor(this.ecoreUtil.allFeatures(this.typeProvider.getRMetaAnnotatedType(constructor).getRType(), context));
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)SimplePackage.Literals.OPERATION__ASSIGN_ROOT)) {
                    if (context instanceof Operation) {
                        Operation op = (Operation)context;
                        ArrayList<RosettaDefinable> outAndAliases = new ArrayList<RosettaDefinable>();
                        Attribute out = this.functionExtensions.getOutput(op.getFunction());
                        if (out != null) {
                            outAndAliases.add(out);
                        }
                        outAndAliases.addAll((Collection<RosettaDefinable>)op.getFunction().getShortcuts());
                        return Scopes.scopeFor(outAndAliases);
                    }
                    return IScope.NULLSCOPE;
                }
                if (reference.equals((Object)SimplePackage.Literals.SEGMENT__FEATURE)) {
                    if (context instanceof Operation) {
                        Operation op = (Operation)context;
                        RMetaAnnotatedType receiverType = this.typeProvider.getRTypeOfSymbol(op.getAssignRoot());
                        Iterable features = this.ecoreUtil.allFeatures(receiverType, context, t -> !(t instanceof REnumType));
                        if (receiverType.getRType() instanceof RDataType) {
                            features = Iterables.concat(features, this.ecoreUtil.getMetaDescriptions(((RDataType)receiverType.getRType()).getMetaAttributes(), context));
                        }
                        return Scopes.scopeFor(features);
                    }
                    if (context instanceof Segment) {
                        Segment seg = (Segment)context;
                        Segment prev = seg.getPrev();
                        if (prev != null && this.ecoreUtil.isResolved(prev.getFeature())) {
                            RMetaAnnotatedType receiverType = this.typeProvider.getRTypeOfFeature(prev.getFeature(), context);
                            return Scopes.scopeFor(this.ecoreUtil.allFeatures(receiverType, context, t -> !(t instanceof REnumType)));
                        }
                        if (context.eContainer() instanceof Operation) {
                            return this.getScope(context.eContainer(), reference);
                        }
                        return this.defaultScope(context, reference);
                    }
                    return this.defaultScope(context, reference);
                }
                if (reference.equals((Object)SimplePackage.Literals.ANNOTATION_PATH_ATTRIBUTE_REFERENCE__ATTRIBUTE)) {
                    if (context instanceof Attribute) {
                        Attribute attr = (Attribute)context;
                        RMetaAnnotatedType t2 = this.typeProvider.getRTypeOfSymbol(attr);
                        return Scopes.scopeFor(this.ecoreUtil.allFeatures(t2, context));
                    }
                } else {
                    if (reference.equals((Object)SimplePackage.Literals.ANNOTATION_PATH__ATTRIBUTE)) {
                        if (context instanceof AnnotationPath) {
                            AnnotationPath ap = (AnnotationPath)context;
                            RMetaAnnotatedType t3 = this.typeProvider.getRMetaAnnotatedType(ap.getReceiver());
                            return Scopes.scopeFor(this.ecoreUtil.allFeatures(t3, context));
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)SimplePackage.Literals.ANNOTATION_DEEP_PATH__ATTRIBUTE)) {
                        if (context instanceof AnnotationDeepPath) {
                            AnnotationDeepPath adp = (AnnotationDeepPath)context;
                            RMetaAnnotatedType t4 = this.typeProvider.getRMetaAnnotatedType(adp.getReceiver());
                            return this.createDeepFeatureScope(t4.getRType());
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL)) {
                        InlineFunction inline;
                        RType expectedType;
                        if (context instanceof Operation) {
                            Operation op = (Operation)context;
                            Function function = op.getFunction();
                            ArrayList<Attribute> inputsAndOutputs = new ArrayList<Attribute>((Collection<Attribute>)function.getInputs());
                            if (function.getOutput() != null) {
                                inputsAndOutputs.add(function.getOutput());
                            }
                            return Scopes.scopeFor(inputsAndOutputs);
                        }
                        Iterable implicitFeatures = this.typeProvider.findFeaturesOfImplicitVariable(context);
                        RMetaAnnotatedType expectedMetaType = this.expectedTypeProvider.getExpectedTypeFromContainer(context);
                        RType rType = expectedType = expectedMetaType == null ? null : expectedMetaType.getRType();
                        if (expectedType instanceof REnumType) {
                            REnumType expectedEnumType = (REnumType)expectedType;
                            implicitFeatures = Iterables.concat(implicitFeatures, expectedEnumType.getAllEnumValues());
                        }
                        if ((inline = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)context, InlineFunction.class)) != null) {
                            IScope ps = this.getSymbolParentScope(context, reference);
                            return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
                        }
                        Function container = (Function)EcoreUtil2.getContainerOfType((EObject)context, Function.class);
                        if (container != null) {
                            IScope ps = this.getSymbolParentScope(context, reference);
                            return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
                        }
                        IScope ps = this.getSymbolParentScope(context, reference);
                        return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
                    }
                    if (reference.equals((Object)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE)) {
                        if (context instanceof RosettaEnumValueReference) {
                            RosettaEnumValueReference enumValueRef = (RosettaEnumValueReference)context;
                            return Scopes.scopeFor(this.rObjectFactory.buildREnumType(enumValueRef.getEnumeration()).getAllEnumValues());
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF)) {
                        RosettaType classRef;
                        if (context instanceof RosettaExternalRegularAttribute && (classRef = ((RosettaExternalClass)context.eContainer()).getTypeRef()) instanceof Data) {
                            Data data = (Data)classRef;
                            return Scopes.scopeFor((Iterable)Iterables.filter((Iterable)Iterables.transform(this.rObjectFactory.buildRDataType(data).getAllAttributes(), RAttribute::getEObject), Objects::nonNull));
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF)) {
                        RosettaType typeRef;
                        if (context instanceof RosettaExternalEnumValue && (typeRef = ((RosettaExternalEnum)context.eContainer()).getTypeRef()) instanceof RosettaEnumeration) {
                            RosettaEnumeration enumRef = (RosettaEnumeration)typeRef;
                            return Scopes.scopeFor(this.rObjectFactory.buildREnumType(enumRef).getAllEnumValues());
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE)) {
                        if (context instanceof AnnotationRef) {
                            AnnotationRef ref = (AnnotationRef)context;
                            Annotation annoRef = ref.getAnnotation();
                            return Scopes.scopeFor(annoRef.getAttributes());
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE)) {
                        if (context instanceof FunctionDispatch) {
                            FunctionDispatch fd = (FunctionDispatch)context;
                            return Scopes.scopeFor(this.functionExtensions.getInputs(fd));
                        }
                        return IScope.NULLSCOPE;
                    }
                    if (reference.equals((Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES)) {
                        return this.filteredScope(this.defaultScope(context, reference), (Predicate<IEObjectDescription>)((Predicate)it -> it.getEClass().equals((Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE)));
                    }
                    if (reference.equals((Object)ExpressionPackage.Literals.SWITCH_CASE_GUARD__REFERENCE_GUARD)) {
                        if (context instanceof SwitchCaseGuard) {
                            SwitchCaseGuard guard = (SwitchCaseGuard)context;
                            RType argumentType = this.typeSystem.stripFromTypeAliases(this.typeProvider.getRMetaAnnotatedType(guard.getCase().getSwitchOperation().getArgument()).getRType());
                            if (argumentType instanceof REnumType) {
                                REnumType argEnumType = (REnumType)argumentType;
                                return Scopes.scopeFor(argEnumType.getAllEnumValues());
                            }
                            if (argumentType instanceof RChoiceType) {
                                RChoiceType argChoiceType = (RChoiceType)argumentType;
                                return Scopes.scopeFor((Iterable)Iterables.transform(argChoiceType.getAllOptions(), RChoiceOption::getEObject));
                            }
                            if (argumentType instanceof RDataType) {
                                return this.filteredScope(this.defaultScope(context, reference), (Predicate<IEObjectDescription>)((Predicate)it -> it.getEClass().equals((Object)SimplePackage.Literals.DATA)));
                            }
                            return IScope.NULLSCOPE;
                        }
                    } else if (reference.equals((Object)ExpressionPackage.Literals.WITH_META_ENTRY__KEY)) {
                        if (context instanceof WithMetaEntry) {
                            Resource resource = context.eResource();
                            if (resource == null || resource.getResourceSet() == null) {
                                return IScope.NULLSCOPE;
                            }
                            Annotation metaData = this.builtinsService.getAnnotationsResource(resource.getResourceSet()).getElements().stream().filter(it -> it instanceof Annotation).map(it -> (Annotation)it).filter(it -> "metadata".equals(it.getName())).findAny().orElseThrow();
                            return Scopes.scopeFor(metaData.getAttributes());
                        }
                        return IScope.NULLSCOPE;
                    }
                }
            }
            return this.defaultScope(context, reference);
        }
        catch (Exception e) {
            LOGGER.error("Error scoping rosetta", (Throwable)e);
            return IScope.NULLSCOPE;
        }
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        return List.of(this.createImportedNamespaceResolver("com.rosetta.model.*", ignoreCase));
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        if (!(context instanceof RosettaModel)) {
            return Collections.emptyList();
        }
        RosettaModel model = (RosettaModel)context;
        ArrayList<ImportNormalizer> imports = new ArrayList<ImportNormalizer>();
        model.getImports().forEach(imp -> {
            ImportNormalizer resolver = this.createImportedNamespaceResolver(imp.getImportedNamespace(), imp.getNamespaceAlias(), ignoreCase);
            if (resolver != null) {
                imports.add(resolver);
            }
        });
        imports.add(this.doCreateImportNormalizer(this.getQualifiedNameConverter().toQualifiedName(model.getName()), true, ignoreCase));
        return imports;
    }

    protected QualifiedName getQualifiedNameOfLocalElement(EObject context) {
        if (context instanceof RosettaModel) {
            return null;
        }
        return super.getQualifiedNameOfLocalElement(context);
    }

    private ImportNormalizer createImportedNamespaceResolver(String namespace, String namespaceAlias, boolean ignoreCase) {
        boolean hasWildCard;
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.getQualifiedNameConverter().toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.isEmpty()) {
            return null;
        }
        QualifiedName qualifiedAlias = namespaceAlias == null ? null : this.getQualifiedNameConverter().toQualifiedName(namespaceAlias);
        boolean bl = hasWildCard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildCard()) : importedNamespace.getLastSegment().equals(this.getWildCard());
        if (hasWildCard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), qualifiedAlias, true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, qualifiedAlias, false, ignoreCase);
    }

    private ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, QualifiedName namespaceAlias, boolean wildcard, boolean ignoreCase) {
        if (namespaceAlias == null) {
            return this.doCreateImportNormalizer(importedNamespace, wildcard, ignoreCase);
        }
        return new AliasAwareImportNormalizer(importedNamespace, namespaceAlias, wildcard, ignoreCase);
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new PatchedImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    private IScope defaultScope(EObject object, EReference reference) {
        return super.getScope(object, reference);
    }

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        IScope localElementsScope = super.getLocalElementsScope(parent, context, reference);
        if (context instanceof RosettaModel) {
            RosettaModel model = (RosettaModel)context;
            localElementsScope = Scopes.scopeFor((Iterable)Iterables.filter(model.getElements(), elem -> reference.getEReferenceType().isSuperTypeOf(elem.eClass()) && !(elem instanceof FunctionDispatch)), (IScope)localElementsScope);
        }
        return localElementsScope;
    }

    private IScope getSymbolParentScope(EObject object, EReference reference) {
        if (object.eContainer() == null) {
            return this.filteredScope(this.defaultScope(object, reference), (Predicate<IEObjectDescription>)((Predicate)descr -> !descr.getEClass().equals((Object)RosettaPackage.Literals.ROSETTA_META_TYPE)));
        }
        IScope parentScope = this.getSymbolParentScope(object.eContainer(), reference);
        if (object instanceof InlineFunction) {
            InlineFunction inlFunc = (InlineFunction)object;
            return Scopes.scopeFor(inlFunc.getParameters(), (IScope)parentScope);
        }
        if (object instanceof Function) {
            Function func = (Function)object;
            ArrayList<Attribute> features = new ArrayList<Attribute>(this.functionExtensions.getInputs(func));
            Attribute out = this.functionExtensions.getOutput(func);
            if (out != null) {
                features.add(out);
            }
            features.addAll((Collection<Attribute>)func.getShortcuts());
            return Scopes.scopeFor(features, (IScope)parentScope);
        }
        if (object instanceof ShortcutDeclaration) {
            ShortcutDeclaration shortcut = (ShortcutDeclaration)object;
            return this.filteredScope(parentScope, (Predicate<IEObjectDescription>)((Predicate)descr -> !descr.getQualifiedName().toString().equals(shortcut.getName())));
        }
        if (object instanceof RosettaTypeAlias) {
            RosettaTypeAlias ta = (RosettaTypeAlias)object;
            return Scopes.scopeFor((Iterable)ta.getParameters(), (IScope)parentScope);
        }
        if (object instanceof Condition) {
            Condition c = (Condition)object;
            return this.filteredScope(parentScope, (Predicate<IEObjectDescription>)((Predicate)descr -> c.isPostCondition() || descr.getEObjectOrProxy().eContainingFeature() != SimplePackage.Literals.FUNCTION__OUTPUT));
        }
        return parentScope;
    }

    private IScope filteredScope(IScope scope, Predicate<IEObjectDescription> filter) {
        return new FilteringScope(scope, filter);
    }

    private IScope createExtendedFeatureScope(EObject receiver, RMetaAnnotatedType metaReceiverType) {
        RType receiverType = metaReceiverType.getRType();
        if (!(!(receiverType instanceof REnumType) || receiver instanceof RosettaSymbolReference && ((RosettaSymbolReference)receiver).getSymbol() instanceof RosettaEnumeration)) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(this.ecoreUtil.allFeatures(metaReceiverType, receiver));
    }

    private IScope createDeepFeatureScope(RType receiverType) {
        RType t = receiverType;
        if (receiverType instanceof RChoiceType) {
            RChoiceType choice = (RChoiceType)receiverType;
            t = choice.asRDataType();
        }
        if (t instanceof RDataType) {
            RDataType dt = (RDataType)t;
            return Scopes.scopeFor((Iterable)Iterables.filter((Iterable)Iterables.transform(this.deepFeatureCallUtil.findDeepFeatures(dt), RAttribute::getEObject), Objects::nonNull));
        }
        return IScope.NULLSCOPE;
    }
}

