/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types.builtin;

import com.regnosys.rosetta.interpreter.RosettaNumberValue;
import com.regnosys.rosetta.interpreter.RosettaStringValue;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import com.rosetta.model.lib.RosettaNumber;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class RStringType
extends RBasicType {
    public static final String MIN_LENGTH_PARAM_NAME = "minLength";
    public static final String MAX_LENGTH_PARAM_NAME = "maxLength";
    public static final String PATTERN_PARAM_NAME = "pattern";
    private final PositiveIntegerInterval interval;
    private final Optional<Pattern> pattern;

    private static LinkedHashMap<String, RosettaValue> createArgumentMap(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        LinkedHashMap<String, RosettaValue> arguments = new LinkedHashMap<String, RosettaValue>();
        int minBound = interval.getMinBound();
        arguments.put(MIN_LENGTH_PARAM_NAME, minBound == 0 ? RosettaValue.empty() : RosettaNumberValue.of(RosettaNumber.valueOf((long)minBound)));
        arguments.put(MAX_LENGTH_PARAM_NAME, interval.getMax().map(m -> RosettaNumberValue.of(RosettaNumber.valueOf((long)m.intValue()))).orElseGet(() -> RosettaValue.empty()));
        arguments.put(PATTERN_PARAM_NAME, pattern.map(p -> RosettaStringValue.of(p.toString())).orElseGet(() -> RosettaValue.empty()));
        return arguments;
    }

    public RStringType(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        super("string", RStringType.createArgumentMap(interval, pattern), true);
        this.interval = interval;
        this.pattern = pattern;
    }

    public RStringType(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        this(new PositiveIntegerInterval(minLength.orElse(0), maxLength), pattern);
    }

    public static RStringType from(Map<String, RosettaValue> values) {
        return new RStringType(values.getOrDefault(MIN_LENGTH_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(d -> d.intValue()), values.getOrDefault(MAX_LENGTH_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(d -> d.intValue()), values.getOrDefault(PATTERN_PARAM_NAME, RosettaValue.empty()).getSingle(String.class).map(s -> Pattern.compile(s)));
    }

    public PositiveIntegerInterval getInterval() {
        return this.interval;
    }

    public Optional<Pattern> getPattern() {
        return this.pattern;
    }

    public RStringType join(RStringType other) {
        Optional<Pattern> joinedPattern = this.pattern.isPresent() ? (other.pattern.isPresent() ? (this.pattern.get().equals(other.pattern.get()) ? this.pattern : Optional.empty()) : this.pattern) : other.pattern;
        return new RStringType(this.interval.minimalCover(other.interval), joinedPattern);
    }
}

