/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.regnosys.rosetta.maven.AbstractRuneGeneratorMojo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.xtext.maven.Language;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class RuneGenerateMojo
extends AbstractRuneGeneratorMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> classpathElements;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> sourceRoots;

    public Set<String> getClasspathElements() {
        LinkedHashSet classpathElements = Sets.newLinkedHashSet();
        classpathElements.addAll(this.classpathElements);
        classpathElements.remove(this.getProject().getBuild().getOutputDirectory());
        classpathElements.remove(this.getProject().getBuild().getTestOutputDirectory());
        LinkedHashSet nonEmptyElements = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)classpathElements, (Predicate)this.emptyStringFilter()));
        return nonEmptyElements;
    }

    protected void configureMavenOutputs() {
        for (Language language : this.getLanguages()) {
            this.addCompileSourceRoots(language);
        }
    }

    protected String getClassOutputDirectory() {
        return this.getProject().getBuild().getOutputDirectory();
    }

    protected List<String> getSourceRoots() {
        return this.sourceRoots;
    }
}

