/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.inject.Injector;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.maven.SingletonGeneratorResourceServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.builder.standalone.ILanguageConfiguration;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class RuneLanguageAccessFactory {
    public Map<String, LanguageAccess> createLanguageAccess(ILanguageConfiguration languageGenConf, String rosettaConfig, ClassLoader compilerClassLoder) {
        HashMap<String, LanguageAccess> result = new HashMap<String, LanguageAccess>();
        try {
            Class<?> loadClass = compilerClassLoder.loadClass(languageGenConf.getSetup());
            if (!RosettaStandaloneSetup.class.isAssignableFrom(loadClass)) {
                throw new IllegalArgumentException("Language setup class " + languageGenConf.getSetup() + " must implement " + RosettaStandaloneSetup.class.getName());
            }
            RosettaStandaloneSetup setup = (RosettaStandaloneSetup)loadClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (rosettaConfig != null) {
                setup.setConfigFile(rosettaConfig);
            }
            Injector injector = setup.createInjectorAndDoEMFRegistration();
            IResourceServiceProvider singletonServiceProvider = (IResourceServiceProvider)injector.getInstance(SingletonGeneratorResourceServiceProvider.class);
            FileExtensionProvider fileExtensionProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
            LanguageAccess languageAccess = new LanguageAccess(languageGenConf.getOutputConfigurations(), singletonServiceProvider, languageGenConf.isJavaSupport());
            for (String extension : fileExtensionProvider.getFileExtensions()) {
                result.put(extension, languageAccess);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load language setup for class '" + rosettaConfig + "'.", e);
        }
        return result;
    }
}

