/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.regnosys.rosetta.generator.RosettaGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneStandaloneBuilder
extends StandaloneBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RuneStandaloneBuilder.class);
    private LanguageAccess rosettaLanguageAccess = null;
    private RosettaGenerator rosettaGenerator = null;
    private boolean needsBeforeAllCall = false;
    private ResourceSet currentResourceSet = null;
    private JavaIoFileSystemAccess currentFileSystemAccess;

    private LanguageAccess getRosettaLanguageAccess() {
        if (this.rosettaLanguageAccess == null) {
            Map languages;
            try {
                Field f = StandaloneBuilder.class.getDeclaredField("languages");
                f.setAccessible(true);
                languages = (Map)f.get((Object)this);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
            this.rosettaLanguageAccess = (LanguageAccess)languages.get("rosetta");
        }
        return this.rosettaLanguageAccess;
    }

    private RosettaGenerator getRosettaGenerator() {
        if (this.rosettaGenerator == null) {
            LanguageAccess access = this.getRosettaLanguageAccess();
            GeneratorDelegate delegate = access.getGenerator();
            try {
                Field f = GeneratorDelegate.class.getDeclaredField("generator");
                f.setAccessible(true);
                this.rosettaGenerator = (RosettaGenerator)f.get(delegate);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return this.rosettaGenerator;
    }

    public boolean launch() {
        this.needsBeforeAllCall = true;
        this.currentResourceSet = null;
        boolean success = super.launch();
        if (success && this.currentResourceSet != null) {
            LOG.info("Starting after all generation");
            GeneratorContext context = new GeneratorContext();
            context.setCancelIndicator(CancelIndicator.NullImpl);
            this.getRosettaGenerator().afterAllGenerate(this.currentResourceSet, (IFileSystemAccess2)this.currentFileSystemAccess, (IGeneratorContext)context);
        }
        return success;
    }

    protected void generate(List<Resource> sourceResources) {
        if (this.needsBeforeAllCall) {
            LOG.info("Starting before all generation");
            this.currentResourceSet = sourceResources.get(0).getResourceSet();
            LanguageAccess access = this.getRosettaLanguageAccess();
            this.currentFileSystemAccess = this.getFileSystemAccess(access);
            GeneratorContext context = new GeneratorContext();
            context.setCancelIndicator(CancelIndicator.NullImpl);
            this.getRosettaGenerator().beforeAllGenerate(this.currentResourceSet, (IFileSystemAccess2)this.currentFileSystemAccess, (IGeneratorContext)context);
            this.needsBeforeAllCall = false;
        }
        super.generate(sourceResources);
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        try {
            Method m = StandaloneBuilder.class.getDeclaredMethod("getFileSystemAccess", LanguageAccess.class);
            m.setAccessible(true);
            return (JavaIoFileSystemAccess)m.invoke((Object)this, language);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

