/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;

@ImplementedBy(value=GetFctvDtDefault.class)
public abstract class GetFctvDt
implements RosettaFunction {
    public Date evaluate(ASICTransactionReport drrReport) {
        Date fctvDt = this.doEvaluate(drrReport);
        return fctvDt;
    }

    protected abstract Date doEvaluate(ASICTransactionReport var1);

    public static class GetFctvDtDefault
    extends GetFctvDt {
        @Override
        protected Date doEvaluate(ASICTransactionReport drrReport) {
            Date fctvDt = null;
            return this.assignOutput(fctvDt, drrReport);
        }

        protected Date assignOutput(Date fctvDt, ASICTransactionReport drrReport) {
            fctvDt = (Date)MapperS.of((Object)drrReport).map("getEffectiveDate", aSICTransactionReport -> aSICTransactionReport.getEffectiveDate()).get();
            return fctvDt;
        }
    }
}

