/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.esma.AmountAndDirection106__1;
import iso20022.auth030.esma.AmountAndDirection106__4;
import iso20022.auth030.esma.Package4__1;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice__2;
import iso20022.auth030.esma.SecuritiesTransactionPrice20Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetPackgDefault.class)
public abstract class GetPackg
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public Package4__1 evaluate(ESMAEMIRTransactionReport drrReport) {
        Package4__1 packg;
        Package4__1.Package4__1Builder packgBuilder = this.doEvaluate(drrReport);
        if (packgBuilder == null) {
            packg = null;
        } else {
            packg = packgBuilder.build();
            this.objectValidator.validate(Package4__1.class, (RosettaModelObject)packg);
        }
        return packg;
    }

    protected abstract Package4__1.Package4__1Builder doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetPackgDefault
    extends GetPackg {
        @Override
        protected Package4__1.Package4__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
            Package4__1.Package4__1Builder packg = Package4__1.builder();
            return this.assignOutput(packg, drrReport);
        }

        protected Package4__1.Package4__1Builder assignOutput(Package4__1.Package4__1Builder packg, ESMAEMIRTransactionReport drrReport) {
            packg = (Package4__1.Package4__1Builder)this.toBuilder((RosettaModelObject)Package4__1.builder().setCmplxTradId((String)MapperS.of((Object)drrReport).map("getPackageIdentifier", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPackageIdentifier()).get()).setPric((SecuritiesTransactionPrice17Choice__2)MapperS.of((Object)drrReport).map("getPackageTransactionPrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPackageTransactionPrice()).mapSingleToItem(item -> {
                AmountAndDirection106__4 ifThenElseResult0 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPackageTransactionPriceNotation", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = AmountAndDirection106__4.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue((BigDecimal)item.map("getPackageTransactionPriceMonetary", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceMonetary()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPackageTransactionPrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPackageTransactionPrice()).map("getPackageTransactionPriceCurrency", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).build();
                }
                BigDecimal ifThenElseResult1 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPackageTransactionPriceNotation", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = (BigDecimal)item.map("getPackageTransactionPricePercentage", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPricePercentage()).get();
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__2.builder().setMntryVal(ifThenElseResult0).setPctg(ifThenElseResult1).build());
            }).get()).setSprd((SecuritiesTransactionPrice20Choice__1)MapperS.of((Object)drrReport).map("getPackageTransactionSpread", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPackageTransactionSpread()).mapSingleToItem(item -> {
                AmountAndDirection106__1 ifThenElseResult1 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPackageTransactionSpreadNotation", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    Boolean ifThenElseResult0 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getPackageTransactionSpreadMonetary", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = false;
                    }
                    ifThenElseResult1 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPackageTransactionSpreadMonetary", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPackageTransactionSpread", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPackageTransactionSpread()).map("getPackageTransactionSpreadCurrency", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build();
                }
                BigDecimal ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPackageTransactionSpreadNotation", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult2 = (BigDecimal)item.map("getPackageTransactionSpreadPercentage", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadPercentage()).get();
                }
                Integer ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPackageTransactionSpreadNotation", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.BASIS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    BigDecimal bigDecimal = (BigDecimal)item.map("getPackageTransactionSpreadBasis", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadBasis()).get();
                    ifThenElseResult3 = bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValueExact());
                }
                return MapperS.of((Object)SecuritiesTransactionPrice20Choice__1.builder().setMntryVal(ifThenElseResult1).setPctg(ifThenElseResult2).setBsisPtSprd(ifThenElseResult3).build());
            }).get()).build());
            return Optional.ofNullable(packg).map(o -> o.prune()).orElse(null);
        }
    }
}

