/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.mas.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.mas.AmountAndDirection106__1;
import iso20022.auth030.mas.ExerciseDate1Choice__1;
import iso20022.auth030.mas.OptionOrSwaption11__1;
import iso20022.auth030.mas.OptionStyle6Code;
import iso20022.auth030.mas.OptionType2Code;
import iso20022.auth030.mas.Schedule4__1;
import iso20022.auth030.mas.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption11__1 evaluate(MASTransactionReport drrReport) {
        OptionOrSwaption11__1 optn;
        OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption11__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport drrReport) {
            OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, MASTransactionReport drrReport) {
            String ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getSettlementCurrency1", mASTransactionReport -> mASTransactionReport.getSettlementCurrency1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : null);
            optn = (OptionOrSwaption11__1.OptionOrSwaption11__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption11__1.builder().setTp((OptionType2Code)MapperS.of((Object)drrReport).map("getOptionType", mASTransactionReport -> mASTransactionReport.getOptionType()).checkedMap("to-enum", OptionType2Code::fromDisplayName, IllegalArgumentException.class).get()).setExrcStyle((OptionStyle6Code)MapperS.of((Object)drrReport).map("getOptionStyle", mASTransactionReport -> mASTransactionReport.getOptionStyle()).checkedMap("to-enum", OptionStyle6Code::fromDisplayName, IllegalArgumentException.class).get()).setExrcDt(ExerciseDate1Choice__1.builder().setFrstExrcDt((Date)MapperS.of((Object)drrReport).map("getFirstExerciseDate", mASTransactionReport -> mASTransactionReport.getFirstExerciseDate()).get()).build()).setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).mapSingleToItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"OPTN"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"SWPT"), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"INTR"), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3) : (String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getStrikePriceDecimal", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceDecimal()).get();
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setDcml(ifThenElseResult3).build());
            }).get()).setStrkPricSchdl(MapperS.of((Object)drrReport).mapC("getStrikePriceSchedule", mASTransactionReport -> mASTransactionReport.getStrikePriceSchedule()).mapItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"OPTN"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"SWPT"), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"CURR"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"INTR"), (CardinalityOperator)CardinalityOperator.All)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = (String)MapperS.of((Object)drrReport).map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getStrikePriceInEffectOnAssociatedEffectiveDateDecimal", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).get();
                }
                return MapperS.of((Object)Schedule4__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setDcml(ifThenElseResult3).build()).build());
            }).getMulti()).setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", mASTransactionReport -> mASTransactionReport.getCallAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getCallCurrency", mASTransactionReport -> mASTransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", mASTransactionReport -> mASTransactionReport.getPutAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPutCurrency", mASTransactionReport -> mASTransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()).get()).setCcy(ifThenElseResult).build()).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

