/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEStrikePriceNotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

@ImplementedBy(value=GetStrikePriceNotationEnumRuleDefault.class)
public abstract class GetStrikePriceNotationEnumRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected CDEStrikePriceNotationEnumRule cDEStrikePriceNotationEnumRule;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected ProductForEvent productForEvent;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class GetStrikePriceNotationEnumRuleDefault
    extends GetStrikePriceNotationEnumRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            output = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.cDEStrikePriceNotationEnumRule.evaluate(input))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? PriceNotationEnum.DECIMAL : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.cDEStrikePriceNotationEnumRule.evaluate(input))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate(this.productForEvent.evaluate(input)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate(this.productForEvent.evaluate(input)))))).getOrDefault(Boolean.valueOf(false)) != false ? PriceNotationEnum.DECIMAL : this.cDEStrikePriceNotationEnumRule.evaluate(input));
            return output;
        }
    }
}

