/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CFTCPart43TransactionReportTypeFormatValidator
implements Validator<CFTCPart43TransactionReport> {
    private List<ComparisonResult> getComparisonResults(CFTCPart43TransactionReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"cleared", (String)o.getCleared(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"counterparty2IdentifierSource", (String)o.getCounterparty2IdentifierSource(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"submitterIdentifier", (String)o.getSubmitterIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"actionType", (String)o.getActionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"eventType", (String)o.getEventType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalAmountLeg1", (BigDecimal)o.getNotionalAmountLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalAmountLeg2", (BigDecimal)o.getNotionalAmountLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalQuantityLeg1", (BigDecimal)o.getNotionalQuantityLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalQuantityLeg2", (BigDecimal)o.getNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityFrequencyLeg1", (String)o.getQuantityFrequencyLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"quantityFrequencyLeg2", (String)o.getQuantityFrequencyLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"quantityFrequencyMultiplierLeg1", (Integer)o.getQuantityFrequencyMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"quantityFrequencyMultiplierLeg2", (Integer)o.getQuantityFrequencyMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureLeg1", (String)o.getQuantityUnitOfMeasureLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureLeg2", (String)o.getQuantityUnitOfMeasureLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityLeg1", (BigDecimal)o.getTotalNotionalQuantityLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityLeg2", (BigDecimal)o.getTotalNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"packageTransactionPriceNotation", (String)o.getPackageTransactionPriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"packageTransactionSpreadNotation", (String)o.getPackageTransactionSpreadNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodLeg1", (String)o.getFloatingRateResetFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodLeg2", (String)o.getFloatingRateResetFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"fixedRatePaymentFrequencyPeriodLeg1", (String)o.getFixedRatePaymentFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"fixedRatePaymentFrequencyPeriodLeg2", (String)o.getFixedRatePaymentFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRatePaymentFrequencyPeriodLeg1", (String)o.getFloatingRatePaymentFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRatePaymentFrequencyPeriodLeg2", (String)o.getFloatingRatePaymentFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierLeg1", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierLeg2", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"exchangeRateLeg1", (BigDecimal)o.getExchangeRateLeg1(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperators.checkNumber((String)"fixedRateLeg1", (BigDecimal)o.getFixedRateLeg1(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRateLeg2", (BigDecimal)o.getFixedRateLeg2(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"price", (BigDecimal)o.getPrice(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"priceNotation", (String)o.getPriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"spreadNotationLeg1", (String)o.getSpreadNotationLeg1(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"spreadNotationLeg2", (String)o.getSpreadNotationLeg2(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"strikePriceNotation", (String)o.getStrikePriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"indexFactor", (BigDecimal)o.getIndexFactor(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"embeddedOptionType", (String)o.getEmbeddedOptionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"settlementLocationLeg1", (String)o.getSettlementLocationLeg1(), (int)1, Optional.of(2), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"settlementLocationLeg2", (String)o.getSettlementLocationLeg2(), (int)1, Optional.of(2), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"platformIdentifier", (String)o.getPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"uniqueSwapIdentifier", (String)o.getUniqueSwapIdentifier(), (int)1, Optional.of(42), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,42}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CFTCPart43TransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCPart43TransactionReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CFTCPart43TransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCPart43TransactionReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

