/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportStrikePriceCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportStrikePriceCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportStrikePriceCondition";
    public static final String DEFINITION = "if postPricedSwapIndicator = False and cftcGuidebook -> optionStyle exists then strikePrice exists else strikePrice is absent";

    public static class NoOp
    implements CFTCPart45TransactionReportStrikePriceCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportStrikePriceCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportStrikePriceCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportStrikePriceCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportStrikePriceCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportStrikePriceCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getStrikePrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getStrikePrice()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getStrikePrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getStrikePrice()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

