/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.meta.RegimeReportingSideMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RegimeReportingSide", builder=RegimeReportingSideBuilderImpl.class, version="5.52.1")
@RuneDataType(value="RegimeReportingSide", model="drr", builder=RegimeReportingSideBuilderImpl.class, version="5.52.1")
public interface RegimeReportingSide
extends RosettaModelObject {
    public static final RegimeReportingSideMeta metaData = new RegimeReportingSideMeta();

    public RegimeNameEnum getRegimeName();

    public SupervisoryBodyEnum getSupervisoryBody();

    public ReportingSide getReportingSide();

    public ReportingSide getDelegatedReportingSide();

    public RegimeReportingSide build();

    public RegimeReportingSideBuilder toBuilder();

    public static RegimeReportingSideBuilder builder() {
        return new RegimeReportingSideBuilderImpl();
    }

    default public RosettaMetaData<? extends RegimeReportingSide> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegimeReportingSide> getType() {
        return RegimeReportingSide.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("regimeName"), RegimeNameEnum.class, (Object)this.getRegimeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("supervisoryBody"), SupervisoryBodyEnum.class, (Object)this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("delegatedReportingSide"), processor, ReportingSide.class, this.getDelegatedReportingSide(), new AttributeMeta[0]);
    }

    public static class RegimeReportingSideBuilderImpl
    implements RegimeReportingSideBuilder {
        protected RegimeNameEnum regimeName;
        protected SupervisoryBodyEnum supervisoryBody;
        protected ReportingSide.ReportingSideBuilder reportingSide;
        protected ReportingSide.ReportingSideBuilder delegatedReportingSide;

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public RegimeNameEnum getRegimeName() {
            return this.regimeName;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public SupervisoryBodyEnum getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingSide")
        @RuneAttribute(value="reportingSide")
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="delegatedReportingSide")
        @RuneAttribute(value="delegatedReportingSide")
        public ReportingSide.ReportingSideBuilder getDelegatedReportingSide() {
            return this.delegatedReportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateDelegatedReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.delegatedReportingSide != null ? this.delegatedReportingSide : (this.delegatedReportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public RegimeReportingSideBuilder setRegimeName(RegimeNameEnum _regimeName) {
            this.regimeName = _regimeName == null ? null : _regimeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public RegimeReportingSideBuilder setSupervisoryBody(SupervisoryBodyEnum _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSide")
        @RuneAttribute(value="reportingSide")
        public RegimeReportingSideBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="delegatedReportingSide")
        @RuneAttribute(value="delegatedReportingSide")
        public RegimeReportingSideBuilder setDelegatedReportingSide(ReportingSide _delegatedReportingSide) {
            this.delegatedReportingSide = _delegatedReportingSide == null ? null : _delegatedReportingSide.toBuilder();
            return this;
        }

        @Override
        public RegimeReportingSide build() {
            return new RegimeReportingSideImpl(this);
        }

        @Override
        public RegimeReportingSideBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimeReportingSideBuilder prune() {
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            if (this.delegatedReportingSide != null && !this.delegatedReportingSide.prune().hasData()) {
                this.delegatedReportingSide = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRegimeName() != null) {
                return true;
            }
            if (this.getSupervisoryBody() != null) {
                return true;
            }
            if (this.getReportingSide() != null && this.getReportingSide().hasData()) {
                return true;
            }
            return this.getDelegatedReportingSide() != null && this.getDelegatedReportingSide().hasData();
        }

        public RegimeReportingSideBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegimeReportingSideBuilder o = (RegimeReportingSideBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelegatedReportingSide(), (RosettaModelObjectBuilder)o.getDelegatedReportingSide(), this::setDelegatedReportingSide);
            merger.mergeBasic((Object)this.getRegimeName(), (Object)o.getRegimeName(), this::setRegimeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSupervisoryBody(), (Object)o.getSupervisoryBody(), this::setSupervisoryBody, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegimeReportingSide _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.regimeName, (Object)_that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.supervisoryBody, (Object)_that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingSide, _that.getReportingSide())) {
                return false;
            }
            return Objects.equals(this.delegatedReportingSide, _that.getDelegatedReportingSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? ((Object)((Object)this.regimeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? ((Object)((Object)this.supervisoryBody)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            _result = 31 * _result + (this.delegatedReportingSide != null ? this.delegatedReportingSide.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegimeReportingSideBuilder {regimeName=" + String.valueOf((Object)this.regimeName) + ", supervisoryBody=" + String.valueOf((Object)this.supervisoryBody) + ", reportingSide=" + String.valueOf(this.reportingSide) + ", delegatedReportingSide=" + String.valueOf(this.delegatedReportingSide) + "}";
        }
    }

    public static interface RegimeReportingSideBuilder
    extends RegimeReportingSide,
    RosettaModelObjectBuilder {
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide();

        @Override
        public ReportingSide.ReportingSideBuilder getReportingSide();

        public ReportingSide.ReportingSideBuilder getOrCreateDelegatedReportingSide();

        @Override
        public ReportingSide.ReportingSideBuilder getDelegatedReportingSide();

        public RegimeReportingSideBuilder setRegimeName(RegimeNameEnum var1);

        public RegimeReportingSideBuilder setSupervisoryBody(SupervisoryBodyEnum var1);

        public RegimeReportingSideBuilder setReportingSide(ReportingSide var1);

        public RegimeReportingSideBuilder setDelegatedReportingSide(ReportingSide var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("regimeName"), RegimeNameEnum.class, (Object)this.getRegimeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("supervisoryBody"), SupervisoryBodyEnum.class, (Object)this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, this.getReportingSide(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("delegatedReportingSide"), processor, ReportingSide.ReportingSideBuilder.class, this.getDelegatedReportingSide(), new AttributeMeta[0]);
        }

        public RegimeReportingSideBuilder prune();
    }

    public static class RegimeReportingSideImpl
    implements RegimeReportingSide {
        private final RegimeNameEnum regimeName;
        private final SupervisoryBodyEnum supervisoryBody;
        private final ReportingSide reportingSide;
        private final ReportingSide delegatedReportingSide;

        protected RegimeReportingSideImpl(RegimeReportingSideBuilder builder) {
            this.regimeName = builder.getRegimeName();
            this.supervisoryBody = builder.getSupervisoryBody();
            this.reportingSide = Optional.ofNullable(builder.getReportingSide()).map(f -> f.build()).orElse(null);
            this.delegatedReportingSide = Optional.ofNullable(builder.getDelegatedReportingSide()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public RegimeNameEnum getRegimeName() {
            return this.regimeName;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public SupervisoryBodyEnum getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingSide")
        @RuneAttribute(value="reportingSide")
        public ReportingSide getReportingSide() {
            return this.reportingSide;
        }

        @Override
        @RosettaAttribute(value="delegatedReportingSide")
        @RuneAttribute(value="delegatedReportingSide")
        public ReportingSide getDelegatedReportingSide() {
            return this.delegatedReportingSide;
        }

        @Override
        public RegimeReportingSide build() {
            return this;
        }

        @Override
        public RegimeReportingSideBuilder toBuilder() {
            RegimeReportingSideBuilder builder = RegimeReportingSide.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimeReportingSideBuilder builder) {
            Optional.ofNullable(this.getRegimeName()).ifPresent(builder::setRegimeName);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getReportingSide()).ifPresent(builder::setReportingSide);
            Optional.ofNullable(this.getDelegatedReportingSide()).ifPresent(builder::setDelegatedReportingSide);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegimeReportingSide _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.regimeName, (Object)_that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.supervisoryBody, (Object)_that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingSide, _that.getReportingSide())) {
                return false;
            }
            return Objects.equals(this.delegatedReportingSide, _that.getDelegatedReportingSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? ((Object)((Object)this.regimeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? ((Object)((Object)this.supervisoryBody)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            _result = 31 * _result + (this.delegatedReportingSide != null ? this.delegatedReportingSide.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegimeReportingSide {regimeName=" + String.valueOf((Object)this.regimeName) + ", supervisoryBody=" + String.valueOf((Object)this.supervisoryBody) + ", reportingSide=" + String.valueOf(this.reportingSide) + ", delegatedReportingSide=" + String.valueOf(this.delegatedReportingSide) + "}";
        }
    }
}

