/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.Party;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=CounterpartiesDefault.class)
public abstract class Counterparties
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Party> evaluate(Trade trade) {
        List counterparties;
        List<Party.PartyBuilder> counterpartiesBuilder = this.doEvaluate(trade);
        if (counterpartiesBuilder == null) {
            counterparties = null;
        } else {
            counterparties = counterpartiesBuilder.stream().map(Party::build).collect(Collectors.toList());
            this.objectValidator.validate(Party.class, counterparties);
        }
        return counterparties;
    }

    protected abstract List<Party.PartyBuilder> doEvaluate(Trade var1);

    public static class CounterpartiesDefault
    extends Counterparties {
        @Override
        protected List<Party.PartyBuilder> doEvaluate(Trade trade) {
            ArrayList<Party.PartyBuilder> counterparties = new ArrayList<Party.PartyBuilder>();
            return this.assignOutput(counterparties, trade);
        }

        protected List<Party.PartyBuilder> assignOutput(List<Party.PartyBuilder> counterparties, Trade trade) {
            counterparties.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty.getValue()).getMulti()));
            return Optional.ofNullable(counterparties).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

