/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.Product;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableQuantityPeriodLeg1Default.class)
public abstract class GetReportableQuantityPeriodLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg1 commodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommodityOption isCommodityOption;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public List<? extends QuantityReportablePeriod> evaluate(Trade trade) {
        List reportablePeriod;
        List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(trade);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantityReportablePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade var1);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(Trade var1);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade var1);

    public static class GetReportableQuantityPeriodLeg1Default
    extends GetReportableQuantityPeriodLeg1 {
        @Override
        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade trade) {
            ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod = new ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder>();
            return this.assignOutput(reportablePeriod, trade);
        }

        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod, Trade trade) {
            if (ExpressionOperators.exists(this.customizedSchedule(trade)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                reportablePeriod.addAll(this.toBuilder(this.quantitySchedule(trade).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).mapItem(quantityPeriod -> {
                    MapperC thenArg0 = this.customizedSchedule(trade).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).filterItemNullSafe(customPeriod -> ExpressionOperators.areEqual((Mapper)quantityPeriod.map("getDate", datedValue -> datedValue.getDate()), (Mapper)customPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                    MapperS thenArg1 = MapperS.of((Object)((SchedulePeriod)thenArg0.get()));
                    return thenArg1.mapSingleToItem(matchingCustomPeriod -> MapperS.of((Object)QuantityReportablePeriod.builder().setPeriodValue((BigDecimal)quantityPeriod.map("getValue", datedValue -> datedValue.getValue()).get()).setPeriodEffectiveDate((Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).get()).setPeriodEndDate((Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).get()).build()));
                }).getMulti()));
            } else {
                reportablePeriod.addAll(this.toBuilder(this.quantitySchedule(trade).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).mapItem(quantityPeriod -> MapperS.of((Object)QuantityReportablePeriod.builder().setPeriodValue((BigDecimal)quantityPeriod.map("getValue", datedValue -> datedValue.getValue()).get()).setPeriodEffectiveDate((Date)quantityPeriod.map("getDate", datedValue -> datedValue.getDate()).get()).setPeriodEndDate(null).build())).getMulti()));
            }
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade) {
            Boolean boolean0 = this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)));
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.productForTrade.evaluate(trade))).map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule());
            }
            Boolean boolean1 = this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)));
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.commodityLeg1.evaluate(this.productForTrade.evaluate(trade))).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            Boolean boolean2 = this.isSingleCommodityPayoutProduct.evaluate(this.productForTrade.evaluate(trade));
            if (boolean2 != null && boolean2.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCommodityOption.evaluate(this.productForTrade.evaluate(trade)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((CalculationSchedule)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSchedule", optionPayout -> optionPayout.getSchedule()).get()));
            }
            Boolean boolean3 = this.isCommodityFloatingPriceForward.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean3 != null && boolean3.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            Boolean boolean4 = this.isCommodityFixedPriceForward.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean4 != null && boolean4.booleanValue()) {
                return MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.getLeg1ResolvablePriceQuantity.evaluate(trade)).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            }
            Boolean _boolean = this.isSingleCommodityPayoutProduct.evaluate(this.productForTrade.evaluate(trade));
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            }
            return MapperS.ofNull();
        }
    }
}

