/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportableStrikePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=EUEMIRReportableStrikePricePeriodDefault.class)
public abstract class EUEMIRReportableStrikePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContinuousPriceSchedule create_ContinuousPriceSchedule;
    @Inject
    protected GetExpirationDate getExpirationDate;
    @Inject
    protected GetReportableStrikePricePeriod getReportableStrikePricePeriod;

    public List<? extends PriceReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
        List emirReportableStrikePricePeriods;
        List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriodsBuilder = this.doEvaluate(transactionReportInstruction);
        if (emirReportableStrikePricePeriodsBuilder == null) {
            emirReportableStrikePricePeriods = null;
        } else {
            emirReportableStrikePricePeriods = emirReportableStrikePricePeriodsBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceReportablePeriod.class, emirReportableStrikePricePeriods);
        }
        return emirReportableStrikePricePeriods;
    }

    protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Date> expirationDate(TransactionReportInstruction var1);

    protected abstract MapperC<? extends PriceReportablePeriod> genericReportableStrikePriceSchedule(TransactionReportInstruction var1);

    public static class EUEMIRReportableStrikePricePeriodDefault
    extends EUEMIRReportableStrikePricePeriod {
        @Override
        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriods = new ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder>();
            return this.assignOutput(emirReportableStrikePricePeriods, transactionReportInstruction);
        }

        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriods, TransactionReportInstruction transactionReportInstruction) {
            emirReportableStrikePricePeriods = this.toBuilder(this.create_ContinuousPriceSchedule.evaluate(this.genericReportableStrikePriceSchedule(transactionReportInstruction).getMulti(), (Date)this.expirationDate(transactionReportInstruction).get()));
            return Optional.ofNullable(emirReportableStrikePricePeriods).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.getExpirationDate.evaluate(transactionReportInstruction));
        }

        @Override
        protected MapperC<? extends PriceReportablePeriod> genericReportableStrikePriceSchedule(TransactionReportInstruction transactionReportInstruction) {
            return MapperC.of(this.getReportableStrikePricePeriod.evaluate(transactionReportInstruction));
        }
    }
}

