/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.Notional;
import drr.regulation.common.functions.PayoutLeg1;
import drr.regulation.common.functions.TradableProductForEvent;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrency1RuleDefault.class)
public abstract class NotionalCurrency1Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected Notional notional;
    @Inject
    protected PayoutLeg1 payoutLeg1;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrency1RuleDefault
    extends NotionalCurrency1Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(reportableEvent -> {
                Boolean _boolean = this.isActionTypeTERM.evaluate((ReportableEvent)thenArg0.get());
                MapperS _thenArg0 = _boolean != null && _boolean != false ? MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)thenArg0.get())).map("getTradableProduct", trade -> trade.getTradableProduct()) : MapperS.of((Object)this.tradableProductForEvent.evaluate((ReportableEvent)thenArg0.get()));
                MapperS _thenArg1 = _thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.payoutLeg1.evaluate((Product)item.map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), (TradeLot)item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ReportableInformation)reportableEvent.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
                return _thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.notional.evaluate((PayoutLegWithAuxiliary)item.get())).map("getUnit", measure -> measure.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

