/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.standards.iso.PriceNotationEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PackageTransactionSpreadPercentage")
@ImplementedBy(value=Default.class)
public interface PackageTransactionSpreadPercentage
extends Validator<PackageTransactionSpread> {
    public static final String NAME = "PackageTransactionSpreadPercentage";
    public static final String DEFINITION = "if packageTransactionSpreadNotation = PriceNotationEnum -> Percentage then packageTransactionSpreadPercentage exists";

    public static class NoOp
    implements PackageTransactionSpreadPercentage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PackageTransactionSpreadPercentage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
            ComparisonResult result = this.executeDataRule(packageTransactionSpread);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PackageTransactionSpreadPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PackageTransactionSpread", (RosettaPath)path, (String)PackageTransactionSpreadPercentage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PackageTransactionSpreadPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PackageTransactionSpread", (RosettaPath)path, (String)PackageTransactionSpreadPercentage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PackageTransactionSpread packageTransactionSpread) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)packageTransactionSpread).map("getPackageTransactionSpreadNotation", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)packageTransactionSpread).map("getPackageTransactionSpreadPercentage", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadPercentage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

