/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportablePricePeriod;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.jfsa.rewrite.trade.PriceScheduleReport;
import drr.regulation.jfsa.rewrite.trade.reports.ContractPriceScheduleEffectiveDateRule;
import drr.regulation.jfsa.rewrite.trade.reports.ContractPriceScheduleEndDateRule;
import drr.regulation.jfsa.rewrite.trade.reports.PriceScheduleAmountFormatDecimalRule;
import drr.regulation.jfsa.rewrite.trade.reports.PriceScheduleAmountFormatMonetaryRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=PriceScheduleRuleDefault.class)
public abstract class PriceScheduleRule
implements ReportFunction<TransactionReportInstruction, List<? extends PriceScheduleReport>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ContractPriceScheduleEffectiveDateRule contractPriceScheduleEffectiveDateRule;
    @Inject
    protected ContractPriceScheduleEndDateRule contractPriceScheduleEndDateRule;
    @Inject
    protected GetReportablePricePeriod getReportablePricePeriod;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected PriceScheduleAmountFormatDecimalRule priceScheduleAmountFormatDecimalRule;
    @Inject
    protected PriceScheduleAmountFormatMonetaryRule priceScheduleAmountFormatMonetaryRule;

    public List<? extends PriceScheduleReport> evaluate(TransactionReportInstruction input) {
        List output;
        List<PriceScheduleReport.PriceScheduleReportBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(PriceScheduleReport::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceScheduleReport.class, output);
        }
        return output;
    }

    protected abstract List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class PriceScheduleRuleDefault
    extends PriceScheduleRule {
        @Override
        protected List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<PriceScheduleReport.PriceScheduleReportBuilder> output = new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<PriceScheduleReport.PriceScheduleReportBuilder> assignOutput(List<PriceScheduleReport.PriceScheduleReportBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> MapperC.of(this.getReportablePricePeriod.evaluate((ReportableEvent)item.get())));
            MapperC thenArg2 = thenArg1.mapItem(item -> MapperS.of((Object)PriceScheduleReport.builder().setEffectiveDate(this.contractPriceScheduleEffectiveDateRule.evaluate((PriceReportablePeriod)item.get())).setEndDate(this.contractPriceScheduleEndDateRule.evaluate((PriceReportablePeriod)item.get())).setPriceMonetary(this.priceScheduleAmountFormatMonetaryRule.evaluate((PriceReportablePeriod)item.get())).setPriceDecimal(this.priceScheduleAmountFormatDecimalRule.evaluate((PriceReportablePeriod)item.get())).build()));
            output = this.toBuilder(thenArg2.sort(item -> item.map("getEffectiveDate", priceScheduleReport -> priceScheduleReport.getEffectiveDate())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

