/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.regulation.jfsa.rewrite.trade.reports.GetStrikePriceNotationEnumRule;
import drr.standards.iosco.cde.reports.CDEStrikePriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceDecimalRuleDefault.class)
public abstract class StrikePriceDecimalRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected CDEStrikePriceRule cDEStrikePriceRule;
    @Inject
    protected FormatToBaseOneRate formatToBaseOneRate;
    @Inject
    protected GetStrikePriceNotationEnumRule getStrikePriceNotationEnumRule;
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected MultiplyPrice multiplyPrice;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceDecimalRuleDefault
    extends StrikePriceDecimalRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.getStrikePriceNotationEnumRule.evaluate((TransactionReportInstruction)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.multiplyPrice.evaluate(this.cDEStrikePriceRule.evaluate((TransactionReportInstruction)item.get()), this.getStrikePriceNotationEnumRule.evaluate((TransactionReportInstruction)item.get())));
                }
                return MapperS.ofNull();
            });
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOneRate.evaluate((BigDecimal)thenArg1.get())).get();
            return output;
        }
    }
}

