/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JFSATransactionReportTypeFormatValidator
implements Validator<JFSATransactionReport> {
    private List<ComparisonResult> getComparisonResults(JFSATransactionReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"entityResponsibleForReporting", (String)o.getEntityResponsibleForReporting(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"direction1", (String)o.getDirection1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"direction2Leg1", (String)o.getDirection2Leg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"direction2Leg2", (String)o.getDirection2Leg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"submitterIdentifier", (String)o.getSubmitterIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"newSDRIdentifier", (String)o.getNewSDRIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"originalSwapSDRIdentifier", (String)o.getOriginalSwapSDRIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"cleared", (String)o.getCleared(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"centralCounterparty", (String)o.getCentralCounterparty(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"clearingMember", (String)o.getClearingMember(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"platformIdentifier", (String)o.getPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"confirmed", (String)o.getConfirmed(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"clearingAccountOrigin", (String)o.getClearingAccountOrigin(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"originalSwapUTI", (String)o.getOriginalSwapUTI(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"originalSwapUTIProprietary", (String)o.getOriginalSwapUTIProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"uti", (String)o.getUti(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"utiProprietary", (String)o.getUtiProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"priorUti", (String)o.getPriorUti(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"priorUtiProprietary", (String)o.getPriorUtiProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"fixedRatePaymentFrequencyPeriodLeg1", (String)o.getFixedRatePaymentFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"fixedRatePaymentFrequencyPeriodLeg2", (String)o.getFixedRatePaymentFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRatePaymentFrequencyPeriodLeg1", (String)o.getFloatingRatePaymentFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRatePaymentFrequencyPeriodLeg2", (String)o.getFloatingRatePaymentFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierLeg1", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierLeg2", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodLeg1", (String)o.getFloatingRateResetFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodOfLeg2", (String)o.getFloatingRateResetFrequencyPeriodOfLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"priceNotation", (String)o.getPriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRateLeg1", (BigDecimal)o.getFixedRateLeg1(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRateLeg2", (BigDecimal)o.getFixedRateLeg2(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"spreadNotationOfLeg1", (String)o.getSpreadNotationOfLeg1(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"spreadNotationOfLeg2", (String)o.getSpreadNotationOfLeg2(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"strikePriceNotation", (String)o.getStrikePriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"exchangeRate", (BigDecimal)o.getExchangeRate(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperators.checkNumber((String)"notionalLeg1", (BigDecimal)o.getNotionalLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalLeg2", (BigDecimal)o.getNotionalLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureLeg1", (String)o.getQuantityUnitOfMeasureLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureLeg2", (String)o.getQuantityUnitOfMeasureLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityLeg1", (BigDecimal)o.getTotalNotionalQuantityLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityLeg2", (BigDecimal)o.getTotalNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"actionType", (String)o.getActionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"eventType", (String)o.getEventType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"eventIdentifier", (String)o.getEventIdentifier(), (int)1, Optional.of(52), Optional.empty()), ExpressionOperators.checkNumber((String)"indexFactor", (BigDecimal)o.getIndexFactor(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"embeddedOptionType", (String)o.getEmbeddedOptionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"deliveryType", (String)o.getDeliveryType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"assetClass", (String)o.getAssetClass(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"underlyingIdentificationType", (String)o.getUnderlyingIdentificationType(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"underlyingIdentification", (String)o.getUnderlyingIdentification(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperators.checkString((String)"underlyingIndexIndicator", (String)o.getUnderlyingIndexIndicator(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"nameOfTheUnderlyingIndex", (String)o.getNameOfTheUnderlyingIndex(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), ExpressionOperators.checkString((String)"indicatorOfTheFloatingRateOfLeg1", (String)o.getIndicatorOfTheFloatingRateOfLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"indicatorOfTheFloatingRateOfLeg2", (String)o.getIndicatorOfTheFloatingRateOfLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"nameOfTheFloatingRateOfLeg1", (String)o.getNameOfTheFloatingRateOfLeg1(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), ExpressionOperators.checkString((String)"nameOfTheFloatingRateOfLeg2", (String)o.getNameOfTheFloatingRateOfLeg2(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), ExpressionOperators.checkString((String)"floatingRateReferencePeriodOfLeg1TimePeriod", (String)o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"floatingRateReferencePeriodOfLeg2TimePeriod", (String)o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateReferencePeriodOfLeg1Multiplier", (Integer)o.getFloatingRateReferencePeriodOfLeg1Multiplier(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateReferencePeriodOfLeg2Multiplier", (Integer)o.getFloatingRateReferencePeriodOfLeg2Multiplier(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"seniority", (String)o.getSeniority(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"series", (Integer)o.getSeries(), Optional.of(5), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"version", (Integer)o.getVersion(), Optional.of(5), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"cdSIndexAttachmentPoint", (BigDecimal)o.getCdSIndexAttachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"cdSIndexDetachmentPoint", (BigDecimal)o.getCdSIndexDetachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"customBasketCode", (String)o.getCustomBasketCode(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"contractType", (String)o.getContractType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"optionStyle", (String)o.getOptionStyle(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"optionType", (String)o.getOptionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"packageIdentifier", (String)o.getPackageIdentifier(), (int)1, Optional.of(35), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), ExpressionOperators.checkString((String)"packageTransactionPriceNotation", (String)o.getPackageTransactionPriceNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkString((String)"packageTransactionSpreadNotation", (String)o.getPackageTransactionSpreadNotation(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperators.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"JFSATransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"JFSATransactionReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"JFSATransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"JFSATransactionReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

