/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOne18Rate;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDESpreadLeg1Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=SpreadOfLeg1MonetaryRuleDefault.class)
public abstract class SpreadOfLeg1MonetaryRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected CDESpreadLeg1Rule cDESpreadLeg1Rule;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected GetPriceNotation getPriceNotation;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected MultiplyPrice multiplyPrice;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class SpreadOfLeg1MonetaryRuleDefault
    extends SpreadOfLeg1MonetaryRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                PriceSchedule priceSchedule = this.cDESpreadLeg1Rule.evaluate((TransactionReportInstruction)item.get());
                return priceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
            });
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = (ReferenceWithMetaPriceSchedule)item.get();
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.getPriceNotation.evaluate(referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule2 = (ReferenceWithMetaPriceSchedule)item.get();
                    return MapperS.of((Object)this.multiplyPrice.evaluate((BigDecimal)item.map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()).get(), this.getPriceNotation.evaluate(referenceWithMetaPriceSchedule2 == null ? null : referenceWithMetaPriceSchedule2.getValue())));
                }
                return MapperS.ofNull();
            });
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

