/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MASTransactionReportTypeFormatValidator
implements Validator<MASTransactionReport> {
    private List<ComparisonResult> getComparisonResults(MASTransactionReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"reportingSpecifiedPerson", (String)o.getReportingSpecifiedPerson(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"priorUTI", (String)o.getPriorUTI(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"priorUTIProprietary", (String)o.getPriorUTIProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"assetClass", (String)o.getAssetClass(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"underlying", (String)o.getUnderlying(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperators.checkString((String)"underlyingIdentificationType", (String)o.getUnderlyingIdentificationType(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"underlyingIdOther", (String)o.getUnderlyingIdOther(), (int)1, Optional.of(210), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,210}"))), ExpressionOperators.checkString((String)"nameOfTheUnderlyingIndex", (String)o.getNameOfTheUnderlyingIndex(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), ExpressionOperators.checkNumber((String)"fixedRateOfLeg1", (BigDecimal)o.getFixedRateOfLeg1(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"identifierOfFloatingRateOfLeg1", (String)o.getIdentifierOfFloatingRateOfLeg1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperators.checkString((String)"nameOfTheFloatingRateOfLeg1", (String)o.getNameOfTheFloatingRateOfLeg1(), (int)1, Optional.of(350), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_]{1,350}"))), ExpressionOperators.checkNumber((String)"fixedRateOfLeg2", (BigDecimal)o.getFixedRateOfLeg2(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"identifierOfFloatingRateOfLeg2", (String)o.getIdentifierOfFloatingRateOfLeg2(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperators.checkString((String)"nameOfTheFloatingRateOfLeg2", (String)o.getNameOfTheFloatingRateOfLeg2(), (int)1, Optional.of(350), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_]{1,350}"))), ExpressionOperators.checkString((String)"optionType", (String)o.getOptionType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"optionStyle", (String)o.getOptionStyle(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"swapLinkID", (String)o.getSwapLinkID(), (int)1, Optional.of(35), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), ExpressionOperators.checkString((String)"packageIdentifier", (String)o.getPackageIdentifier(), (int)1, Optional.of(35), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), ExpressionOperators.checkString((String)"cleared", (String)o.getCleared(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperators.checkString((String)"centralCounterparty", (String)o.getCentralCounterparty(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"clearingMember", (String)o.getClearingMember(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"platformIdentifier", (String)o.getPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"bookingLocation", (String)o.getBookingLocation(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}"))), ExpressionOperators.checkString((String)"traderLocation", (String)o.getTraderLocation(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}"))), ExpressionOperators.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkNumber((String)"notionalAmountOfTheContractOrLeg1", (BigDecimal)o.getNotionalAmountOfTheContractOrLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalAmountOfLeg2", (BigDecimal)o.getNotionalAmountOfLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityOfTheContractOrLeg1", (BigDecimal)o.getTotalNotionalQuantityOfTheContractOrLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureForTheContractOrLeg1", (String)o.getQuantityUnitOfMeasureForTheContractOrLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalQuantityOfTheContractOrLeg1", (BigDecimal)o.getNotionalQuantityOfTheContractOrLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityFrequencyOfTheContractOrLeg1", (String)o.getQuantityFrequencyOfTheContractOrLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"quantityFrequencyMultiplierOfTheContractOrLeg1", (Integer)o.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantityLeg2", (BigDecimal)o.getTotalNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasureLeg2", (String)o.getQuantityUnitOfMeasureLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalQuantityOfLeg2", (BigDecimal)o.getNotionalQuantityOfLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityFrequencyOfLeg2", (String)o.getQuantityFrequencyOfLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"quantityFrequencyMultiplierOfLeg2", (Integer)o.getQuantityFrequencyMultiplierOfLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"exchangeRate", (BigDecimal)o.getExchangeRate(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodOfLeg1", (String)o.getFloatingRateResetFrequencyPeriodOfLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierOfLeg1", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"floatingRateResetFrequencyPeriodOfLeg2", (String)o.getFloatingRateResetFrequencyPeriodOfLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRateResetFrequencyPeriodMultiplierOfLeg2", (Integer)o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierOfLeg1", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRatePaymentFrequencyPeriodMultiplierOfLeg2", (Integer)o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", (Integer)o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"counterparty2Name", (String)o.getCounterparty2Name(), (int)1, Optional.of(150), Optional.empty()), ExpressionOperators.checkString((String)"executionAgentOfCounterparty2DTCC", (String)o.getExecutionAgentOfCounterparty2DTCC(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"MASTransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"MASTransactionReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"MASTransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"MASTransactionReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

