/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import iso20022.auth030.mas.PaymentType4Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0127_02")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0127_02
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0127_02";
    public static final String DEFINITION = "if actionType = ActionTypeEnum -> TERM to-string and [\"INTR\", \"CURR\", \"COMM\", \"EQUI\"] any = assetClass and (otherPayment -> amount exists or otherPayment -> currency exists or otherPayment -> payer exists or otherPayment -> receiver exists) then otherPayment -> paymentType exists and otherPayment -> paymentType all = PaymentType4Code -> UWIN and (if otherPayment -> paymentType count <> otherPayment -> amount count or otherPayment -> paymentType count <> otherPayment -> currency count or otherPayment -> paymentType count <> otherPayment -> date count or otherPayment -> paymentType count <> otherPayment -> payer count or otherPayment -> paymentType count <> otherPayment -> receiver count then False)";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0127_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0127_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0127_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0127_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0127_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0127_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)).map("to-string", ActionTypeEnum::toDisplayString), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)"INTR"), MapperS.of((Object)"CURR"), MapperS.of((Object)"COMM"), MapperS.of((Object)"EQUI")}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)) != false ? ComparisonResult.of((Mapper)MapperS.of((Object)false)) : ComparisonResult.successEmptyOperand((String)"");
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType())).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), (Mapper)MapperS.of((Object)PaymentType4Code.UWIN), (CardinalityOperator)CardinalityOperator.All)).and(ifThenElseResult);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

