/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.base.math.ArithmeticOperationEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CDEPackageTransactionSpreadRuleDefault.class)
public abstract class CDEPackageTransactionSpreadRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected GetPackageInformation getPackageInformation;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class CDEPackageTransactionSpreadRuleDefault
    extends CDEPackageTransactionSpreadRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)this.getPackageInformation.evaluate(input)).map("getPrice", identifiedList -> identifiedList.getPrice());
            output = (BigDecimal)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getArithmeticOperator", price -> price.getArithmeticOperator()), (Mapper)MapperS.of((Object)ArithmeticOperationEnum.ADD), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getValue", price -> price.getValue());
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

