/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Contract_StrikePrice;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CDEStrikePriceRuleDefault.class)
public abstract class CDEStrikePriceRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class CDEStrikePriceRuleDefault
    extends CDEStrikePriceRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            output = (BigDecimal)MapperC.of(this.contract_StrikePrice.evaluate(input)).map("getValue", priceSchedule -> priceSchedule.getValue()).get();
            return output;
        }
    }
}

