/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.postprocess;

import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PathCountProcessor
extends SimpleProcessor {
    private static final RosettaPath GLOBAL_REFERENCE = RosettaPath.valueOf((String)"globalReference");
    private static final RosettaPath GLOBAL_KEY = RosettaPath.valueOf((String)"globalKey");
    private final PathReport report = new PathReport();

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
        return instance != null && !this.isResolvedValueWithReference(instance, parent);
    }

    @Override
    public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, Collection<? extends T> instances, RosettaModelObject parent, AttributeMeta ... metas) {
        if (instances == null) {
            return;
        }
        int i = 0;
        for (T instance : instances) {
            this.processBasic(path.withIndex(i++), rosettaType, instance, parent, metas);
        }
    }

    @Override
    public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, T instance, RosettaModelObject parent, AttributeMeta ... metas) {
        if (instance == null || this.isGlobalKey(parent, path) || this.isGlobalReferenceKey(parent, path)) {
            return;
        }
        this.report.collectedPaths.put(path, instance);
    }

    private boolean isResolvedValueWithReference(RosettaModelObject instance, RosettaModelObject parent) {
        if (this.isResolvedValue(instance, parent)) {
            ReferenceWithMeta referenceWithMeta = (ReferenceWithMeta)parent;
            boolean isGlobalReferenceSet = referenceWithMeta.getGlobalReference() != null;
            boolean isExternalReferenceSet = referenceWithMeta.getExternalReference() != null;
            boolean isScopedReferenceSet = Optional.ofNullable(referenceWithMeta.getReference()).map(Reference::getReference).isPresent();
            return isScopedReferenceSet || isGlobalReferenceSet || isExternalReferenceSet;
        }
        return false;
    }

    private boolean isResolvedValue(RosettaModelObject instance, RosettaModelObject parent) {
        return parent instanceof ReferenceWithMeta && !(instance instanceof Reference);
    }

    private boolean isGlobalReferenceKey(RosettaModelObject parent, RosettaPath path) {
        return parent instanceof ReferenceWithMeta && path.endsWith(GLOBAL_REFERENCE);
    }

    private boolean isGlobalKey(RosettaModelObject parent, RosettaPath path) {
        return parent instanceof MetaFields && path.endsWith(GLOBAL_KEY);
    }

    public PathReport report() {
        return this.report;
    }

    public static class PathReport
    implements Processor.Report {
        private final Map<RosettaPath, Object> collectedPaths = new HashMap<RosettaPath, Object>();

        public Map<RosettaPath, Object> getCollectedPaths() {
            return this.collectedPaths;
        }
    }
}

