/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.tuple;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.collect.tuple.Tuple;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ObjDoublePair<A>
implements ImmutableBean,
Tuple,
Comparable<ObjDoublePair<A>>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final A first;
    @PropertyDefinition
    private final double second;
    private static final long serialVersionUID = 1L;

    public static <A> ObjDoublePair<A> of(A first, double second) {
        return new ObjDoublePair<A>(first, second);
    }

    public static <A> ObjDoublePair<A> ofPair(Pair<A, Double> pair) {
        ArgChecker.notNull(pair, "pair");
        return new ObjDoublePair<A>(pair.getFirst(), pair.getSecond());
    }

    @Override
    public int size() {
        return 2;
    }

    public ImmutableList<Object> elements() {
        return ImmutableList.of(this.first, (Object)this.second);
    }

    public Pair<A, Double> toPair() {
        return Pair.of(this.first, this.second);
    }

    @Override
    public int compareTo(ObjDoublePair<A> other) {
        return ComparisonChain.start().compare((Comparable)this.first, (Comparable)other.first).compare(this.second, other.second).result();
    }

    public String toString() {
        return "" + '[' + this.first + ", " + this.second + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaObjDoublePair(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private ObjDoublePair(A first, double second) {
        JodaBeanUtils.notNull(first, (String)"first");
        this.first = first;
        this.second = second;
    }

    public Meta<A> metaBean() {
        return Meta.INSTANCE;
    }

    public A getFirst() {
        return this.first;
    }

    public double getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ObjDoublePair other = (ObjDoublePair)obj;
            return JodaBeanUtils.equal(this.first, other.first) && JodaBeanUtils.equal((double)this.second, (double)other.second);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.first);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.second);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<A>
    extends DirectPrivateBeanBuilder<ObjDoublePair<A>> {
        private A first;
        private double second;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<A> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    this.first = newValue;
                    break;
                }
                case -906279820: {
                    this.second = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ObjDoublePair<A> build() {
            return new ObjDoublePair(this.first, this.second);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ObjDoublePair.Builder{");
            buf.append("first").append('=').append(JodaBeanUtils.toString(this.first)).append(',').append(' ');
            buf.append("second").append('=').append(JodaBeanUtils.toString((Object)this.second));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<A>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<A> first = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"first", ObjDoublePair.class, Object.class);
        private final MetaProperty<Double> second = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"second", ObjDoublePair.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"first", "second"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ObjDoublePair<A>> builder() {
            return new Builder();
        }

        public Class<? extends ObjDoublePair<A>> beanType() {
            return ObjDoublePair.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<A> first() {
            return this.first;
        }

        public MetaProperty<Double> second() {
            return this.second;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return ((ObjDoublePair)bean).getFirst();
                }
                case -906279820: {
                    return ((ObjDoublePair)bean).getSecond();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

