# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.collateral.EligibleCollateralCriteria import EligibleCollateralCriteria

__all__ = ['MergeEligibleCollateralCriteria']


@replaceable
def MergeEligibleCollateralCriteria(criteria1: EligibleCollateralCriteria, criteria2: EligibleCollateralCriteria) -> EligibleCollateralCriteria:
    """
    Java implementation merges criteria1 and criteria2.
    
    Parameters 
    ----------
    criteria1 : EligibleCollateralCriteria
    
    criteria2 : EligibleCollateralCriteria
    
    Returns
    -------
    criteria : EligibleCollateralCriteria
    
    """
    self = inspect.currentframe()
    
    
    criteria = rosetta_resolve_attr(self, "criteria")
    
    
    return criteria

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
