package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.Counterparty46__3;
import iso20022.auth030.asic.PartyIdentification248Choice__3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class Counterparty46__3Validator implements Validator<Counterparty46__3> {

	private List<ComparisonResult> getComparisonResults(Counterparty46__3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("idTp", (PartyIdentification248Choice__3) o.getIdTp() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<Counterparty46__3> validate(RosettaPath path, Counterparty46__3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("Counterparty46__3", ValidationType.CARDINALITY, "Counterparty46__3", path, "", error);
		}
		return success("Counterparty46__3", ValidationType.CARDINALITY, "Counterparty46__3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Counterparty46__3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Counterparty46__3", ValidationType.CARDINALITY, "Counterparty46__3", path, "", res.getError());
				}
				return success("Counterparty46__3", ValidationType.CARDINALITY, "Counterparty46__3", path, "");
			})
			.collect(toList());
	}

}
