package iso20022.auth030.esma.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.MetalCommodityNonPrecious2;
import iso20022.auth030.esma.validation.MetalCommodityNonPrecious2TypeFormatValidator;
import iso20022.auth030.esma.validation.MetalCommodityNonPrecious2Validator;
import iso20022.auth030.esma.validation.exists.MetalCommodityNonPrecious2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=MetalCommodityNonPrecious2.class)
public class MetalCommodityNonPrecious2Meta implements RosettaMetaData<MetalCommodityNonPrecious2> {

	@Override
	public List<Validator<? super MetalCommodityNonPrecious2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super MetalCommodityNonPrecious2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}

	@Override
	public Validator<? super MetalCommodityNonPrecious2> validator() {
		return new MetalCommodityNonPrecious2Validator();
	}

	@Override
	public Validator<? super MetalCommodityNonPrecious2> typeFormatValidator() {
		return new MetalCommodityNonPrecious2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super MetalCommodityNonPrecious2, Set<String>> onlyExistsValidator() {
		return new MetalCommodityNonPrecious2OnlyExistsValidator();
	}
}
