package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassProductType5Code;
import iso20022.auth030.fca.AssetClassSubProductType49Code;
import iso20022.auth030.fca.FertilizerCommodityOther2__1;
import iso20022.auth030.fca.FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder;
import iso20022.auth030.fca.FertilizerCommodityOther2__1.FertilizerCommodityOther2__1BuilderImpl;
import iso20022.auth030.fca.FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Impl;
import iso20022.auth030.fca.meta.FertilizerCommodityOther2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Other fertlizer commodity derivative.
 * @version ${project.version}
 */
@RosettaDataType(value="FertilizerCommodityOther2__1", builder=FertilizerCommodityOther2__1.FertilizerCommodityOther2__1BuilderImpl.class, version="${project.version}")
public interface FertilizerCommodityOther2__1 extends RosettaModelObject {

	FertilizerCommodityOther2__1Meta metaData = new FertilizerCommodityOther2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType5Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType49Code getSubPdct();

	/*********************** Build Methods  ***********************/
	FertilizerCommodityOther2__1 build();
	
	FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder toBuilder();
	
	static FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder builder() {
		return new FertilizerCommodityOther2__1.FertilizerCommodityOther2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FertilizerCommodityOther2__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends FertilizerCommodityOther2__1> getType() {
		return FertilizerCommodityOther2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FertilizerCommodityOther2__1Builder extends FertilizerCommodityOther2__1, RosettaModelObjectBuilder {
		FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder setBasePdct(AssetClassProductType5Code basePdct);
		FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
		}
		

		FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder prune();
	}

	/*********************** Immutable Implementation of FertilizerCommodityOther2__1  ***********************/
	class FertilizerCommodityOther2__1Impl implements FertilizerCommodityOther2__1 {
		private final AssetClassProductType5Code basePdct;
		private final AssetClassSubProductType49Code subPdct;
		
		protected FertilizerCommodityOther2__1Impl(FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public FertilizerCommodityOther2__1 build() {
			return this;
		}
		
		@Override
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder toBuilder() {
			FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityOther2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FertilizerCommodityOther2__1  ***********************/
	class FertilizerCommodityOther2__1BuilderImpl implements FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder {
	
		protected AssetClassProductType5Code basePdct;
		protected AssetClassSubProductType49Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder setBasePdct(AssetClassProductType5Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public FertilizerCommodityOther2__1 build() {
			return new FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Impl(this);
		}
		
		@Override
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder o = (FertilizerCommodityOther2__1.FertilizerCommodityOther2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityOther2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
