package iso20022.auth030.fca.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.AssetClassCommodity6Choice__2;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodity6Choice__2Choice")
@ImplementedBy(AssetClassCommodity6Choice2Choice.Default.class)
public interface AssetClassCommodity6Choice2Choice extends Validator<AssetClassCommodity6Choice__2> {
	
	String NAME = "AssetClassCommodity6Choice__2Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodity6Choice__2> validate(RosettaPath path, AssetClassCommodity6Choice__2 assetClassCommodity6Choice__2);
	
	class Default implements AssetClassCommodity6Choice2Choice {
	
		@Override
		public ValidationResult<AssetClassCommodity6Choice__2> validate(RosettaPath path, AssetClassCommodity6Choice__2 assetClassCommodity6Choice__2) {
			ComparisonResult result = executeDataRule(assetClassCommodity6Choice__2);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodity6Choice__2", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodity6Choice__2", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodity6Choice__2 assetClassCommodity6Choice__2) {
			try {
				return choice(MapperS.of(assetClassCommodity6Choice__2), Arrays.asList("agrcltrl", "nrgy", "envttl", "frtlzr", "frght", "indstrlPdct", "infltn", "metl", "multiCmmdtyExtc", "offclEcnmcSttstcs", "othr", "othrC10", "ppr", "plprpln"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodity6Choice2Choice {
	
		@Override
		public ValidationResult<AssetClassCommodity6Choice__2> validate(RosettaPath path, AssetClassCommodity6Choice__2 assetClassCommodity6Choice__2) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodity6Choice__2", path, DEFINITION);
		}
	}
}
