package iso20022.auth030.fca.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.fca.AssetClassCommodityPolypropylene4Choice__1;
import iso20022.auth030.fca.PolypropyleneCommodityOther2__1;
import iso20022.auth030.fca.PolypropyleneCommodityPlastic2__1;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AssetClassCommodityPolypropylene4Choice__1OnlyExistsValidator implements ValidatorWithArg<AssetClassCommodityPolypropylene4Choice__1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AssetClassCommodityPolypropylene4Choice__1> ValidationResult<AssetClassCommodityPolypropylene4Choice__1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("plstc", ExistenceChecker.isSet((PolypropyleneCommodityPlastic2__1) o.getPlstc()))
				.put("othr", ExistenceChecker.isSet((PolypropyleneCommodityOther2__1) o.getOthr()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AssetClassCommodityPolypropylene4Choice__1", ValidationType.ONLY_EXISTS, "AssetClassCommodityPolypropylene4Choice__1", path, "");
		}
		return failure("AssetClassCommodityPolypropylene4Choice__1", ValidationType.ONLY_EXISTS, "AssetClassCommodityPolypropylene4Choice__1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
