package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.FixedRate10__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class FixedRate10__1TypeFormatValidator implements Validator<FixedRate10__1> {

	private List<ComparisonResult> getComparisonResults(FixedRate10__1 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<FixedRate10__1> validate(RosettaPath path, FixedRate10__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("FixedRate10__1", ValidationType.TYPE_FORMAT, "FixedRate10__1", path, "", error);
		}
		return success("FixedRate10__1", ValidationType.TYPE_FORMAT, "FixedRate10__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FixedRate10__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FixedRate10__1", ValidationType.TYPE_FORMAT, "FixedRate10__1", path, "", res.getError());
				}
				return success("FixedRate10__1", ValidationType.TYPE_FORMAT, "FixedRate10__1", path, "");
			})
			.collect(toList());
	}

}
