package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.AssetClassDetailedSubProductType31Code;
import iso20022.auth030.hkma.tr.AssetClassProductType2Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType7Code;
import iso20022.auth030.hkma.tr.EnergyCommodityNaturalGas3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class EnergyCommodityNaturalGas3Validator implements Validator<EnergyCommodityNaturalGas3> {

	private List<ComparisonResult> getComparisonResults(EnergyCommodityNaturalGas3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("basePdct", (AssetClassProductType2Code) o.getBasePdct() != null ? 1 : 0, 1, 1), 
				checkCardinality("subPdct", (AssetClassSubProductType7Code) o.getSubPdct() != null ? 1 : 0, 0, 1), 
				checkCardinality("addtlSubPdct", (AssetClassDetailedSubProductType31Code) o.getAddtlSubPdct() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<EnergyCommodityNaturalGas3> validate(RosettaPath path, EnergyCommodityNaturalGas3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("EnergyCommodityNaturalGas3", ValidationType.CARDINALITY, "EnergyCommodityNaturalGas3", path, "", error);
		}
		return success("EnergyCommodityNaturalGas3", ValidationType.CARDINALITY, "EnergyCommodityNaturalGas3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, EnergyCommodityNaturalGas3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("EnergyCommodityNaturalGas3", ValidationType.CARDINALITY, "EnergyCommodityNaturalGas3", path, "", res.getError());
				}
				return success("EnergyCommodityNaturalGas3", ValidationType.CARDINALITY, "EnergyCommodityNaturalGas3", path, "");
			})
			.collect(toList());
	}

}
