package iso20022.auth030.mas.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.mas.CommonTradeDataReport71__5;
import iso20022.auth030.mas.TradeTransaction50__5;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CommonTradeDataReport71__5OnlyExistsValidator implements ValidatorWithArg<CommonTradeDataReport71__5, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CommonTradeDataReport71__5> ValidationResult<CommonTradeDataReport71__5> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("txData", ExistenceChecker.isSet((TradeTransaction50__5) o.getTxData()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CommonTradeDataReport71__5", ValidationType.ONLY_EXISTS, "CommonTradeDataReport71__5", path, "");
		}
		return failure("CommonTradeDataReport71__5", ValidationType.ONLY_EXISTS, "CommonTradeDataReport71__5", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
