package iso20022.auth108.hkma.tr.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth108.hkma.tr.PortfolioIdentification3;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class PortfolioIdentification3OnlyExistsValidator implements ValidatorWithArg<PortfolioIdentification3, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends PortfolioIdentification3> ValidationResult<PortfolioIdentification3> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("cd", ExistenceChecker.isSet((String) o.getCd()))
				.put("prtflTxXmptn", ExistenceChecker.isSet((Boolean) o.getPrtflTxXmptn()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("PortfolioIdentification3", ValidationType.ONLY_EXISTS, "PortfolioIdentification3", path, "");
		}
		return failure("PortfolioIdentification3", ValidationType.ONLY_EXISTS, "PortfolioIdentification3", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
