package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.StrikePriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__1;
import iso20022.auth030.jfsa.OptionBarrierLevel1Choice__1;
import iso20022.auth030.jfsa.OptionMultipleBarrierLevels1__1;
import iso20022.auth030.jfsa.OptionOrSwaption11__1;
import iso20022.auth030.jfsa.Schedule4__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice23Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetOptn1.GetOptn1Default.class)
public abstract class GetOptn1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;
	@Inject protected GetCallAmt getCallAmt;
	@Inject protected GetExrcDt getExrcDt;
	@Inject protected GetExrcStyle getExrcStyle;
	@Inject protected GetMbddTp getMbddTp;
	@Inject protected GetMtrtyDtOfUndrlyg getMtrtyDtOfUndrlyg;
	@Inject protected GetPrmAmt getPrmAmt;
	@Inject protected GetPrmPmtDt getPrmPmtDt;
	@Inject protected GetPutAmt getPutAmt;
	@Inject protected GetStrkPric getStrkPric;
	@Inject protected GetTp getTp;
	@Inject protected StringLength stringLength;
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return optn 
	*/
	public OptionOrSwaption11__1 evaluate(JFSATransactionReport drrReport) {
		OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = doEvaluate(drrReport);
		
		final OptionOrSwaption11__1 optn;
		if (optnBuilder == null) {
			optn = null;
		} else {
			optn = optnBuilder.build();
			objectValidator.validate(OptionOrSwaption11__1.class, optn);
		}
		
		return optn;
	}

	protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class GetOptn1Default extends GetOptn1 {
		@Override
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(JFSATransactionReport drrReport) {
			OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
			return assignOutput(optn, drrReport);
		}
		
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, JFSATransactionReport drrReport) {
			AmountAndDirection106__1 ifThenElseResult1 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getSingleBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				Boolean ifThenElseResult0 = null;
				if (lessThan(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult0 = false;
				}
				ifThenElseResult1 = AmountAndDirection106__1.builder()
					.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
						.setValue(abs.evaluate(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary()).get()))
						.setCcy(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<ISOCurrencyCodeEnum>map("getSingleBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
						.build())
					.setSgn(ifThenElseResult0)
					.build();
			}
			BigDecimal ifThenElseResult2 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getSingleBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getSingleBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceDecimal()).get();
			}
			AmountAndDirection106__1 ifThenElseResult4 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getLowerBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				Boolean ifThenElseResult3 = null;
				if (lessThan(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getLowerBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult3 = false;
				}
				ifThenElseResult4 = AmountAndDirection106__1.builder()
					.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
						.setValue(abs.evaluate(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getLowerBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceMonetary()).get()))
						.setCcy(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<ISOCurrencyCodeEnum>map("getLowerBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
						.build())
					.setSgn(ifThenElseResult3)
					.build();
			}
			BigDecimal ifThenElseResult5 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getLowerBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult5 = MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getLowerBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceDecimal()).get();
			}
			AmountAndDirection106__1 ifThenElseResult7 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getUpperBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				Boolean ifThenElseResult6 = null;
				if (lessThan(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getUpperBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult6 = false;
				}
				ifThenElseResult7 = AmountAndDirection106__1.builder()
					.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
						.setValue(abs.evaluate(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getUpperBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceMonetary()).get()))
						.setCcy(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<ISOCurrencyCodeEnum>map("getUpperBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
						.build())
					.setSgn(ifThenElseResult6)
					.build();
			}
			BigDecimal ifThenElseResult8 = null;
			if (areEqual(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<PriceNotationEnum>map("getUpperBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult8 = MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).<BigDecimal>map("getUpperBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceDecimal()).get();
			}
			optn = toBuilder(OptionOrSwaption11__1.builder()
				.setTp(getTp.evaluate(drrReport))
				.setMbddTp(getMbddTp.evaluate(drrReport))
				.setExrcStyle(getExrcStyle.evaluate(drrReport))
				.setExrcDt(getExrcDt.evaluate(drrReport))
				.setStrkPric(getStrkPric.evaluate(drrReport))
				.setStrkPricSchdl(MapperS.of(drrReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", jFSATransactionReport -> jFSATransactionReport.getStrikePriceSchedule())
					.mapItem(item -> {
						AmountAndDirection106__1 _ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							final String _ifThenElseResult0;
							if (greaterThan(MapperS.of(stringLength.evaluate(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), MapperS.of(3), CardinalityOperator.All).getOrDefault(false)) {
								_ifThenElseResult0 = subString.evaluate(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3);
							} else {
								_ifThenElseResult0 = MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
							}
							Boolean _ifThenElseResult1 = null;
							if (lessThan(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								_ifThenElseResult1 = false;
							}
							_ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).get()))
									.setCcy(_ifThenElseResult0)
									.build())
								.setSgn(_ifThenElseResult1)
								.build();
						}
						BigDecimal _ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							_ifThenElseResult3 = item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateDecimal", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).get();
						}
						return MapperS.of(Schedule4__1.builder()
							.setUadjstdFctvDt(item.<Date>map("getEffectiveDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDateStrikePrice()).get())
							.setUadjstdEndDt(item.<Date>map("getEndDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDateStrikePrice()).get())
							.setPric(SecuritiesTransactionPrice17Choice__1.builder()
								.setMntryVal(_ifThenElseResult2)
								.setDcml(_ifThenElseResult3)
								.build())
							.build());
					}).getMulti())
				.setCallAmt(getCallAmt.evaluate(drrReport))
				.setPutAmt(getPutAmt.evaluate(drrReport))
				.setPrmAmt(getPrmAmt.evaluate(drrReport))
				.setPrmPmtDt(getPrmPmtDt.evaluate(drrReport))
				.setMtrtyDtOfUndrlyg(getMtrtyDtOfUndrlyg.evaluate(drrReport))
				.setBrrrLvls(OptionBarrierLevel1Choice__1.builder()
					.setSngl(SecuritiesTransactionPrice23Choice__1.builder()
						.setMntryVal(ifThenElseResult1)
						.setDcml(ifThenElseResult2)
						.build())
					.setMltpl(OptionMultipleBarrierLevels1__1.builder()
						.setLwrLvl(SecuritiesTransactionPrice23Choice__1.builder()
							.setMntryVal(ifThenElseResult4)
							.setDcml(ifThenElseResult5)
							.build())
						.setUpperLvl(SecuritiesTransactionPrice23Choice__1.builder()
							.setMntryVal(ifThenElseResult7)
							.setDcml(ifThenElseResult8)
							.build())
						.build())
					.build())
				.build());
			
			return Optional.ofNullable(optn)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
