package drr.regulation.asic.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.trade.meta.ASICCustomBasketMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Specifies the identifiers for custom Basket
 * @version 5.52.1
 */
@RosettaDataType(value="ASICCustomBasket", builder=ASICCustomBasket.ASICCustomBasketBuilderImpl.class, version="5.52.1")
@RuneDataType(value="ASICCustomBasket", model="drr", builder=ASICCustomBasket.ASICCustomBasketBuilderImpl.class, version="5.52.1")
public interface ASICCustomBasket extends RosettaModelObject {

	ASICCustomBasketMeta metaData = new ASICCustomBasketMeta();

	/*********************** Getter Methods  ***********************/
	String getBasketStructurerID();
	String getCustomBasketID();

	/*********************** Build Methods  ***********************/
	ASICCustomBasket build();
	
	ASICCustomBasket.ASICCustomBasketBuilder toBuilder();
	
	static ASICCustomBasket.ASICCustomBasketBuilder builder() {
		return new ASICCustomBasket.ASICCustomBasketBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ASICCustomBasket> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ASICCustomBasket> getType() {
		return ASICCustomBasket.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basketStructurerID"), String.class, getBasketStructurerID(), this);
		processor.processBasic(path.newSubPath("customBasketID"), String.class, getCustomBasketID(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ASICCustomBasketBuilder extends ASICCustomBasket, RosettaModelObjectBuilder {
		ASICCustomBasket.ASICCustomBasketBuilder setBasketStructurerID(String basketStructurerID);
		ASICCustomBasket.ASICCustomBasketBuilder setCustomBasketID(String customBasketID);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basketStructurerID"), String.class, getBasketStructurerID(), this);
			processor.processBasic(path.newSubPath("customBasketID"), String.class, getCustomBasketID(), this);
		}
		

		ASICCustomBasket.ASICCustomBasketBuilder prune();
	}

	/*********************** Immutable Implementation of ASICCustomBasket  ***********************/
	class ASICCustomBasketImpl implements ASICCustomBasket {
		private final String basketStructurerID;
		private final String customBasketID;
		
		protected ASICCustomBasketImpl(ASICCustomBasket.ASICCustomBasketBuilder builder) {
			this.basketStructurerID = builder.getBasketStructurerID();
			this.customBasketID = builder.getCustomBasketID();
		}
		
		@Override
		@RosettaAttribute("basketStructurerID")
		@RuneAttribute("basketStructurerID")
		public String getBasketStructurerID() {
			return basketStructurerID;
		}
		
		@Override
		@RosettaAttribute("customBasketID")
		@RuneAttribute("customBasketID")
		public String getCustomBasketID() {
			return customBasketID;
		}
		
		@Override
		public ASICCustomBasket build() {
			return this;
		}
		
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder toBuilder() {
			ASICCustomBasket.ASICCustomBasketBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ASICCustomBasket.ASICCustomBasketBuilder builder) {
			ofNullable(getBasketStructurerID()).ifPresent(builder::setBasketStructurerID);
			ofNullable(getCustomBasketID()).ifPresent(builder::setCustomBasketID);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICCustomBasket _that = getType().cast(o);
		
			if (!Objects.equals(basketStructurerID, _that.getBasketStructurerID())) return false;
			if (!Objects.equals(customBasketID, _that.getCustomBasketID())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basketStructurerID != null ? basketStructurerID.hashCode() : 0);
			_result = 31 * _result + (customBasketID != null ? customBasketID.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICCustomBasket {" +
				"basketStructurerID=" + this.basketStructurerID + ", " +
				"customBasketID=" + this.customBasketID +
			'}';
		}
	}

	/*********************** Builder Implementation of ASICCustomBasket  ***********************/
	class ASICCustomBasketBuilderImpl implements ASICCustomBasket.ASICCustomBasketBuilder {
	
		protected String basketStructurerID;
		protected String customBasketID;
		
		@Override
		@RosettaAttribute("basketStructurerID")
		@RuneAttribute("basketStructurerID")
		public String getBasketStructurerID() {
			return basketStructurerID;
		}
		
		@Override
		@RosettaAttribute("customBasketID")
		@RuneAttribute("customBasketID")
		public String getCustomBasketID() {
			return customBasketID;
		}
		
		@RosettaAttribute("basketStructurerID")
		@RuneAttribute("basketStructurerID")
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder setBasketStructurerID(String _basketStructurerID) {
			this.basketStructurerID = _basketStructurerID == null ? null : _basketStructurerID;
			return this;
		}
		
		@RosettaAttribute("customBasketID")
		@RuneAttribute("customBasketID")
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder setCustomBasketID(String _customBasketID) {
			this.customBasketID = _customBasketID == null ? null : _customBasketID;
			return this;
		}
		
		@Override
		public ASICCustomBasket build() {
			return new ASICCustomBasket.ASICCustomBasketImpl(this);
		}
		
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasketStructurerID()!=null) return true;
			if (getCustomBasketID()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ASICCustomBasket.ASICCustomBasketBuilder o = (ASICCustomBasket.ASICCustomBasketBuilder) other;
			
			
			merger.mergeBasic(getBasketStructurerID(), o.getBasketStructurerID(), this::setBasketStructurerID);
			merger.mergeBasic(getCustomBasketID(), o.getCustomBasketID(), this::setCustomBasketID);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICCustomBasket _that = getType().cast(o);
		
			if (!Objects.equals(basketStructurerID, _that.getBasketStructurerID())) return false;
			if (!Objects.equals(customBasketID, _that.getCustomBasketID())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basketStructurerID != null ? basketStructurerID.hashCode() : 0);
			_result = 31 * _result + (customBasketID != null ? customBasketID.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICCustomBasketBuilder {" +
				"basketStructurerID=" + this.basketStructurerID + ", " +
				"customBasketID=" + this.customBasketID +
			'}';
		}
	}
}
