package drr.regulation.asic.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.upi.AnnaDsbUpiRequestAndType;
import drr.regulation.asic.rewrite.trade.meta.ASICNonReportableMeta;
import drr.standards.iso.upi.AnnaDsbUpiRecord;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.52.1
 */
@RosettaDataType(value="ASICNonReportable", builder=ASICNonReportable.ASICNonReportableBuilderImpl.class, version="5.52.1")
@RuneDataType(value="ASICNonReportable", model="drr", builder=ASICNonReportable.ASICNonReportableBuilderImpl.class, version="5.52.1")
public interface ASICNonReportable extends RosettaModelObject {

	ASICNonReportableMeta metaData = new ASICNonReportableMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Populated by pre-enrichment process
	 */
	EnrichmentData getEnrichment();
	AnnaDsbUpiRequestAndType getPreUpiData();
	AnnaDsbUpiRecord getPostUpiData();

	/*********************** Build Methods  ***********************/
	ASICNonReportable build();
	
	ASICNonReportable.ASICNonReportableBuilder toBuilder();
	
	static ASICNonReportable.ASICNonReportableBuilder builder() {
		return new ASICNonReportable.ASICNonReportableBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ASICNonReportable> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ASICNonReportable> getType() {
		return ASICNonReportable.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, getEnrichment());
		processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.class, getPreUpiData());
		processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.class, getPostUpiData());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ASICNonReportableBuilder extends ASICNonReportable, RosettaModelObjectBuilder {
		EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();
		@Override
		EnrichmentData.EnrichmentDataBuilder getEnrichment();
		AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData();
		@Override
		AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData();
		AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData();
		@Override
		AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData();
		ASICNonReportable.ASICNonReportableBuilder setEnrichment(EnrichmentData enrichment);
		ASICNonReportable.ASICNonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType preUpiData);
		ASICNonReportable.ASICNonReportableBuilder setPostUpiData(AnnaDsbUpiRecord postUpiData);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, getEnrichment());
			processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder.class, getPreUpiData());
			processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder.class, getPostUpiData());
		}
		

		ASICNonReportable.ASICNonReportableBuilder prune();
	}

	/*********************** Immutable Implementation of ASICNonReportable  ***********************/
	class ASICNonReportableImpl implements ASICNonReportable {
		private final EnrichmentData enrichment;
		private final AnnaDsbUpiRequestAndType preUpiData;
		private final AnnaDsbUpiRecord postUpiData;
		
		protected ASICNonReportableImpl(ASICNonReportable.ASICNonReportableBuilder builder) {
			this.enrichment = ofNullable(builder.getEnrichment()).map(f->f.build()).orElse(null);
			this.preUpiData = ofNullable(builder.getPreUpiData()).map(f->f.build()).orElse(null);
			this.postUpiData = ofNullable(builder.getPostUpiData()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData getEnrichment() {
			return enrichment;
		}
		
		@Override
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		public AnnaDsbUpiRequestAndType getPreUpiData() {
			return preUpiData;
		}
		
		@Override
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		public AnnaDsbUpiRecord getPostUpiData() {
			return postUpiData;
		}
		
		@Override
		public ASICNonReportable build() {
			return this;
		}
		
		@Override
		public ASICNonReportable.ASICNonReportableBuilder toBuilder() {
			ASICNonReportable.ASICNonReportableBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ASICNonReportable.ASICNonReportableBuilder builder) {
			ofNullable(getEnrichment()).ifPresent(builder::setEnrichment);
			ofNullable(getPreUpiData()).ifPresent(builder::setPreUpiData);
			ofNullable(getPostUpiData()).ifPresent(builder::setPostUpiData);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICNonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(preUpiData, _that.getPreUpiData())) return false;
			if (!Objects.equals(postUpiData, _that.getPostUpiData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (preUpiData != null ? preUpiData.hashCode() : 0);
			_result = 31 * _result + (postUpiData != null ? postUpiData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICNonReportable {" +
				"enrichment=" + this.enrichment + ", " +
				"preUpiData=" + this.preUpiData + ", " +
				"postUpiData=" + this.postUpiData +
			'}';
		}
	}

	/*********************** Builder Implementation of ASICNonReportable  ***********************/
	class ASICNonReportableBuilderImpl implements ASICNonReportable.ASICNonReportableBuilder {
	
		protected EnrichmentData.EnrichmentDataBuilder enrichment;
		protected AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder preUpiData;
		protected AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder postUpiData;
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
			return enrichment;
		}
		
		@Override
		public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
			EnrichmentData.EnrichmentDataBuilder result;
			if (enrichment!=null) {
				result = enrichment;
			}
			else {
				result = enrichment = EnrichmentData.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData() {
			return preUpiData;
		}
		
		@Override
		public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData() {
			AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder result;
			if (preUpiData!=null) {
				result = preUpiData;
			}
			else {
				result = preUpiData = AnnaDsbUpiRequestAndType.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData() {
			return postUpiData;
		}
		
		@Override
		public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData() {
			AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder result;
			if (postUpiData!=null) {
				result = postUpiData;
			}
			else {
				result = postUpiData = AnnaDsbUpiRecord.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		@Override
		public ASICNonReportable.ASICNonReportableBuilder setEnrichment(EnrichmentData _enrichment) {
			this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
			return this;
		}
		
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		@Override
		public ASICNonReportable.ASICNonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType _preUpiData) {
			this.preUpiData = _preUpiData == null ? null : _preUpiData.toBuilder();
			return this;
		}
		
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		@Override
		public ASICNonReportable.ASICNonReportableBuilder setPostUpiData(AnnaDsbUpiRecord _postUpiData) {
			this.postUpiData = _postUpiData == null ? null : _postUpiData.toBuilder();
			return this;
		}
		
		@Override
		public ASICNonReportable build() {
			return new ASICNonReportable.ASICNonReportableImpl(this);
		}
		
		@Override
		public ASICNonReportable.ASICNonReportableBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICNonReportable.ASICNonReportableBuilder prune() {
			if (enrichment!=null && !enrichment.prune().hasData()) enrichment = null;
			if (preUpiData!=null && !preUpiData.prune().hasData()) preUpiData = null;
			if (postUpiData!=null && !postUpiData.prune().hasData()) postUpiData = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEnrichment()!=null && getEnrichment().hasData()) return true;
			if (getPreUpiData()!=null && getPreUpiData().hasData()) return true;
			if (getPostUpiData()!=null && getPostUpiData().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICNonReportable.ASICNonReportableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ASICNonReportable.ASICNonReportableBuilder o = (ASICNonReportable.ASICNonReportableBuilder) other;
			
			merger.mergeRosetta(getEnrichment(), o.getEnrichment(), this::setEnrichment);
			merger.mergeRosetta(getPreUpiData(), o.getPreUpiData(), this::setPreUpiData);
			merger.mergeRosetta(getPostUpiData(), o.getPostUpiData(), this::setPostUpiData);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICNonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(preUpiData, _that.getPreUpiData())) return false;
			if (!Objects.equals(postUpiData, _that.getPostUpiData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (preUpiData != null ? preUpiData.hashCode() : 0);
			_result = 31 * _result + (postUpiData != null ? postUpiData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICNonReportableBuilder {" +
				"enrichment=" + this.enrichment + ", " +
				"preUpiData=" + this.preUpiData + ", " +
				"postUpiData=" + this.postUpiData +
			'}';
		}
	}
}
