package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ASICPartyInformation;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SmallScaleBuySideEntityIndicatorRule.SmallScaleBuySideEntityIndicatorRuleDefault.class)
public abstract class SmallScaleBuySideEntityIndicatorRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SmallScaleBuySideEntityIndicatorRuleDefault extends SmallScaleBuySideEntityIndicatorRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(reportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = thenArg.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation());
					final MapperC<PartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperListOfLists<ASICPartyInformation> thenArg2 = thenArg1
						.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<ASICPartyInformation>map("getAsicPartyInformation", reportingRegime -> reportingRegime.getAsicPartyInformation()));
					final MapperC<ASICPartyInformation> thenArg3 = thenArg2
						.flattenList();
					final MapperS<ASICPartyInformation> thenArg4 = MapperS.of(thenArg3.get());
					return thenArg4
						.mapSingleToItem(item -> {
							if (exists(item.<Boolean>map("getSmallScaleBuySideIndicator", aSICPartyInformation -> aSICPartyInformation.getSmallScaleBuySideIndicator())).and(areEqual(item.<Boolean>map("getSmallScaleBuySideIndicator", aSICPartyInformation -> aSICPartyInformation.getSmallScaleBuySideIndicator()), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
								return MapperS.of("SSBS");
							}
							return MapperS.<String>ofNull();
						});
				}).get();
			
			return output;
		}
	}
}
