package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class ASICCustomBasketTypeFormatValidator implements Validator<ASICCustomBasket> {

	private List<ComparisonResult> getComparisonResults(ASICCustomBasket o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("basketStructurerID", o.getBasketStructurerID(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("customBasketID", o.getCustomBasketID(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICCustomBasket o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICCustomBasket", ValidationResult.ValidationType.TYPE_FORMAT, "ASICCustomBasket", path, "", res.getError());
				}
				return success("ASICCustomBasket", ValidationResult.ValidationType.TYPE_FORMAT, "ASICCustomBasket", path, "");
			})
			.collect(toList());
	}

}
